/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testng.DependencyMap;
import org.testng.ITestNGMethod;
import org.testng.TestRunner;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.DynamicGraph;
import org.testng.internal.WrappedTestNGMethod;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public final class DynamicGraphHelper {
    private DynamicGraphHelper() {
    }

    public static DynamicGraph<ITestNGMethod> createDynamicGraph(ITestNGMethod[] methods, XmlTest xmlTest) {
        DynamicGraph<ITestNGMethod> result = new DynamicGraph<ITestNGMethod>();
        DependencyMap dependencyMap = new DependencyMap(methods);
        AtomicReference<Boolean> hasDependencies = new AtomicReference<Boolean>(false);
        Arrays.stream(methods).forEach(m3 -> {
            boolean added = result.addNode((ITestNGMethod)m3);
            if (!added) {
                result.addNode(new WrappedTestNGMethod((ITestNGMethod)m3));
            }
            String[] dependentMethods = m3.getMethodsDependedUpon();
            ((Stream)Arrays.stream(dependentMethods).parallel()).forEach(d -> {
                ITestNGMethod dm = dependencyMap.getMethodDependingOn((String)d, (ITestNGMethod)m3);
                if (m3 != dm) {
                    result.addEdge(TestRunner.PriorityWeight.dependsOnMethods.ordinal(), (ITestNGMethod)m3, dm);
                }
            });
            String[] dependentGroups = m3.getGroupsDependedUpon();
            if (dependentGroups.length != 0) {
                hasDependencies.set(true);
            }
            ((Stream)Arrays.stream(dependentGroups).parallel()).forEach(d -> {
                List<ITestNGMethod> dg = dependencyMap.getMethodsThatBelongTo((String)d, (ITestNGMethod)m3);
                dg.parallelStream().forEach(ddm -> result.addEdge(TestRunner.PriorityWeight.dependsOnGroups.ordinal(), (ITestNGMethod)m3, (ITestNGMethod)ddm));
            });
        });
        if (!hasDependencies.get().booleanValue() && xmlTest.getParallel() == XmlSuite.ParallelMode.NONE && xmlTest.getPreserveOrder().booleanValue()) {
            ListMultiMap<ITestNGMethod, ITestNGMethod> classDependencies = DynamicGraphHelper.createClassDependencies(methods, xmlTest);
            for (Map.Entry es : classDependencies.entrySet()) {
                for (ITestNGMethod dm : (List)es.getValue()) {
                    result.addEdge(TestRunner.PriorityWeight.preserveOrder.ordinal(), dm, (ITestNGMethod)es.getKey());
                }
            }
        }
        if (DynamicGraphHelper.canGroupByInstances(xmlTest)) {
            ListMultiMap<ITestNGMethod, ITestNGMethod> instanceDependencies = DynamicGraphHelper.createInstanceDependencies(methods);
            for (Map.Entry es : instanceDependencies.entrySet()) {
                result.addEdges(TestRunner.PriorityWeight.groupByInstance.ordinal(), (ITestNGMethod)es.getKey(), (Iterable)es.getValue());
            }
        }
        return result;
    }

    private static Comparator<XmlClass> classComparator() {
        return Comparator.comparingInt(XmlClass::getIndex);
    }

    private static boolean canGroupByInstances(XmlTest xmlTest) {
        return xmlTest.getGroupByInstances() && !xmlTest.getParallel().equals((Object)XmlSuite.ParallelMode.INSTANCES);
    }

    private static ListMultiMap<ITestNGMethod, ITestNGMethod> createClassDependencies(ITestNGMethod[] methods, XmlTest test) {
        Map classes = Maps.newHashMap();
        List<XmlClass> sortedClasses = Lists.newArrayList();
        ListMultiMap<String, ITestNGMethod> methodsFromClass = Maps.newListMultiMap();
        for (ITestNGMethod m3 : methods) {
            methodsFromClass.put(m3.getTestClass().getName(), m3);
        }
        List classesWithMethods = test.getXmlClasses().stream().filter(xmlClass -> methodsFromClass.keySet().contains(xmlClass.getName())).collect(Collectors.toList());
        for (XmlClass c : classesWithMethods) {
            classes.put(c.getName(), new ArrayList());
            if (sortedClasses.contains(c)) continue;
            sortedClasses.add(c);
        }
        sortedClasses.sort(DynamicGraphHelper.classComparator());
        Map<String, Integer> indexedClasses1 = Maps.newHashMap();
        Map<Integer, String> indexedClasses2 = Maps.newHashMap();
        int i2 = 0;
        for (XmlClass c : sortedClasses) {
            indexedClasses1.put(c.getName(), i2);
            indexedClasses2.put(i2, c.getName());
            ++i2;
        }
        ListMultiMap<ITestNGMethod, ITestNGMethod> result = Maps.newListMultiMap();
        for (ITestNGMethod m4 : methods) {
            String name = m4.getTestClass().getName();
            Integer index = (Integer)indexedClasses1.get(name);
            if (index == null || index <= 0) continue;
            String classDependedUpon = (String)indexedClasses2.get(index - 1);
            List methodsDependedUpon = (List)methodsFromClass.get(classDependedUpon);
            for (ITestNGMethod mdu : methodsDependedUpon) {
                result.put(mdu, m4);
            }
        }
        return result;
    }

    private static ListMultiMap<ITestNGMethod, ITestNGMethod> createInstanceDependencies(ITestNGMethod[] methods) {
        ListMultiMap<Object, ITestNGMethod> instanceMap = Maps.newSortedListMultiMap();
        for (ITestNGMethod m3 : methods) {
            instanceMap.put(m3.getInstance(), m3);
        }
        ListMultiMap<ITestNGMethod, ITestNGMethod> result = Maps.newListMultiMap();
        Object previousInstance = null;
        for (Map.Entry es : instanceMap.entrySet()) {
            if (previousInstance == null) {
                previousInstance = es.getKey();
                continue;
            }
            List previousMethods = (List)instanceMap.get(previousInstance);
            Object currentInstance = es.getKey();
            List currentMethods = (List)instanceMap.get(currentInstance);
            for (ITestNGMethod cm : currentMethods) {
                for (ITestNGMethod pm : previousMethods) {
                    result.put(cm, pm);
                }
            }
            previousInstance = currentInstance;
        }
        return result;
    }
}

