/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.testng.SkipException;
import org.testng.TestNGException;

public class TimeBombSkipException
extends SkipException {
    private static final long serialVersionUID = -8599821478834048537L;
    private static final String FORMAT = "yyyy/MM/dd";
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
    private Calendar m_expireDate;
    private DateFormat m_inFormat = this.sdf;
    private DateFormat m_outFormat = this.sdf;

    public TimeBombSkipException(String msg, Date expirationDate) {
        this(msg, expirationDate, FORMAT);
    }

    public TimeBombSkipException(String msg, Date expirationDate, String format) {
        super(msg);
        this.m_inFormat = new SimpleDateFormat(format);
        this.m_outFormat = new SimpleDateFormat(format);
        this.initExpireDate(expirationDate);
    }

    public TimeBombSkipException(String msg, String date) {
        super(msg);
        this.initExpireDate(date);
    }

    public TimeBombSkipException(String msg, String date, String format) {
        this(msg, date, format, format);
    }

    public TimeBombSkipException(String msg, String date, String inFormat, String outFormat) {
        super(msg);
        this.m_inFormat = new SimpleDateFormat(inFormat);
        this.m_outFormat = new SimpleDateFormat(outFormat);
        this.initExpireDate(date);
    }

    public TimeBombSkipException(String msg, Date expirationDate, Throwable cause) {
        super(msg, cause);
        this.initExpireDate(expirationDate);
    }

    public TimeBombSkipException(String msg, Date expirationDate, String format, Throwable cause) {
        super(msg, cause);
        this.m_inFormat = new SimpleDateFormat(format);
        this.m_outFormat = new SimpleDateFormat(format);
        this.initExpireDate(expirationDate);
    }

    public TimeBombSkipException(String msg, String date, Throwable cause) {
        super(msg, cause);
        this.initExpireDate(date);
    }

    public TimeBombSkipException(String msg, String date, String format, Throwable cause) {
        this(msg, date, format, format, cause);
    }

    public TimeBombSkipException(String msg, String date, String inFormat, String outFormat, Throwable cause) {
        super(msg, cause);
        this.m_inFormat = new SimpleDateFormat(inFormat);
        this.m_outFormat = new SimpleDateFormat(outFormat);
        this.initExpireDate(date);
    }

    private void initExpireDate(Date expireDate) {
        this.m_expireDate = Calendar.getInstance();
        this.m_expireDate.setTime(expireDate);
    }

    private void initExpireDate(String date) {
        try {
            Date d = this.m_inFormat.parse(date);
            this.initExpireDate(d);
        }
        catch (ParseException pex) {
            throw new TestNGException("Cannot parse date:" + date + " using pattern: " + this.m_inFormat, pex);
        }
    }

    @Override
    public boolean isSkip() {
        if (null == this.m_expireDate) {
            return false;
        }
        try {
            Calendar now = Calendar.getInstance();
            Date nowDate = this.m_inFormat.parse(this.m_inFormat.format(now.getTime()));
            now.setTime(nowDate);
            return !now.after(this.m_expireDate);
        }
        catch (ParseException pex) {
            throw new TestNGException("Cannot compare dates.");
        }
    }

    @Override
    public String getMessage() {
        if (this.isSkip()) {
            return super.getMessage();
        }
        return super.getMessage() + "; Test must have been enabled by: " + this.m_outFormat.format(this.m_expireDate.getTime());
    }

    @Override
    public void printStackTrace(PrintStream s2) {
        this.reduceStackTrace();
        super.printStackTrace(s2);
    }

    @Override
    public void printStackTrace(PrintWriter s2) {
        this.reduceStackTrace();
        super.printStackTrace(s2);
    }
}

