/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ant;

import java.security.AccessController;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.codehaus.groovy.tools.LoaderConfiguration;
import org.codehaus.groovy.tools.RootLoader;

public class RootLoaderRef
extends MatchingTask {
    private String name;
    private Path taskClasspath;

    public void setRef(String n) {
        this.name = n;
    }

    @Override
    public void execute() throws BuildException {
        if (this.taskClasspath == null || this.taskClasspath.size() == 0) {
            throw new BuildException("no classpath given");
        }
        Project project = this.getProject();
        String[] list = this.taskClasspath.list();
        LoaderConfiguration lc = new LoaderConfiguration();
        for (String s2 : list) {
            if (s2.matches(".*ant-[^/]*jar$") || s2.matches(".*commons-logging-[^/]*jar$") || s2.matches(".*xerces-[^/]*jar$")) continue;
            lc.addFile(s2);
        }
        AntClassLoader loader = AccessController.doPrivileged(() -> new AntClassLoader(new RootLoader(lc), true));
        project.addReference(this.name, loader);
    }

    public void setClasspath(Path classpath) {
        if (this.taskClasspath == null) {
            this.taskClasspath = classpath;
        } else {
            this.taskClasspath.append(classpath);
        }
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path createClasspath() {
        if (this.taskClasspath == null) {
            this.taskClasspath = new Path(this.getProject());
        }
        return this.taskClasspath.createPath();
    }
}

