/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.Map;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.IgnoredTestListener;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitVersionHelper;
import org.apache.tools.ant.util.FileUtils;

public class PlainJUnitResultFormatter
implements JUnitResultFormatter,
IgnoredTestListener {
    private static final double ONE_SECOND = 1000.0;
    private NumberFormat nf = NumberFormat.getInstance();
    private Map<Test, Long> testStarts = new Hashtable<Test, Long>();
    private OutputStream out;
    private StringWriter inner;
    private BufferedWriter wri;
    private Map<Test, Boolean> failed = new Hashtable<Test, Boolean>();
    private String systemOutput = null;
    private String systemError = null;

    public PlainJUnitResultFormatter() {
        this.inner = new StringWriter();
        this.wri = new BufferedWriter(this.inner);
    }

    @Override
    public void setOutput(OutputStream out) {
        this.out = out;
    }

    @Override
    public void setSystemOutput(String out) {
        this.systemOutput = out;
    }

    @Override
    public void setSystemError(String err) {
        this.systemError = err;
    }

    @Override
    public void startTestSuite(JUnitTest suite) throws BuildException {
        if (this.out == null) {
            return;
        }
        try {
            this.out.write(String.format("Testsuite: %s%n", suite.getName()).getBytes());
            this.out.flush();
        }
        catch (IOException ex) {
            throw new BuildException("Unable to write output", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endTestSuite(JUnitTest suite) throws BuildException {
        boolean success = false;
        try {
            this.write(String.format("Tests run: %d, Failures: %d, Errors: %d, Skipped: %d, Time elapsed: %s sec%n", suite.runCount(), suite.failureCount(), suite.errorCount(), suite.skipCount(), this.nf.format((double)suite.getRunTime() / 1000.0)));
            if (this.systemOutput != null && !this.systemOutput.isEmpty()) {
                this.write(String.format("------------- Standard Output ---------------%n", new Object[0]));
                this.write(this.systemOutput);
                this.write(String.format("------------- ---------------- ---------------%n", new Object[0]));
            }
            if (this.systemError != null && !this.systemError.isEmpty()) {
                this.write(String.format("------------- Standard Error -----------------%n", new Object[0]));
                this.write(this.systemError);
                this.write(String.format("------------- ---------------- ---------------%n", new Object[0]));
            }
            this.write(System.lineSeparator());
            if (this.out != null) {
                try {
                    this.wri.flush();
                    this.write(this.inner.toString());
                }
                catch (IOException ioex) {
                    throw new BuildException("Unable to write output", ioex);
                }
            }
            success = true;
        }
        finally {
            if (this.out != null) {
                try {
                    this.wri.close();
                }
                catch (IOException ioex) {
                    if (success) {
                        throw new BuildException("Unable to flush output", ioex);
                    }
                }
                finally {
                    if (this.out != System.out && this.out != System.err) {
                        FileUtils.close(this.out);
                    }
                    this.wri = null;
                    this.out = null;
                }
            }
        }
    }

    @Override
    public void startTest(Test t) {
        this.testStarts.put(t, System.currentTimeMillis());
        this.failed.put(t, Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endTest(Test test) {
        if (Boolean.TRUE.equals(this.failed.get(test))) {
            return;
        }
        BufferedWriter bufferedWriter = this.wri;
        synchronized (bufferedWriter) {
            try {
                this.wri.write("Testcase: " + JUnitVersionHelper.getTestCaseName(test));
                Long l = this.testStarts.get(test);
                double seconds = 0.0;
                if (l != null) {
                    seconds = (double)(System.currentTimeMillis() - l) / 1000.0;
                }
                this.wri.write(" took " + this.nf.format(seconds) + " sec");
                this.wri.newLine();
            }
            catch (IOException ex) {
                throw new BuildException(ex);
            }
        }
    }

    public void addFailure(Test test, Throwable t) {
        this.formatError("\tFAILED", test, t);
    }

    @Override
    public void addFailure(Test test, AssertionFailedError t) {
        this.addFailure(test, (Throwable)((Object)t));
    }

    @Override
    public void addError(Test test, Throwable t) {
        this.formatError("\tCaused an ERROR", test, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formatError(String type, Test test, Throwable t) {
        BufferedWriter bufferedWriter = this.wri;
        synchronized (bufferedWriter) {
            if (test != null) {
                this.endTest(test);
                this.failed.put(test, Boolean.TRUE);
            }
            try {
                this.wri.write(type);
                this.wri.newLine();
                this.wri.write(String.valueOf(t.getMessage()));
                this.wri.newLine();
                String strace = JUnitTestRunner.getFilteredTrace(t);
                this.wri.write(strace);
                this.wri.newLine();
            }
            catch (IOException ex) {
                throw new BuildException(ex);
            }
        }
    }

    @Override
    public void testIgnored(Test test) {
        this.formatSkip(test, JUnitVersionHelper.getIgnoreMessage(test));
    }

    public void formatSkip(Test test, String message) {
        if (test != null) {
            this.endTest(test);
        }
        try {
            this.wri.write("\tSKIPPED");
            if (message != null) {
                this.wri.write(": ");
                this.wri.write(message);
            }
            this.wri.newLine();
        }
        catch (IOException ex) {
            throw new BuildException(ex);
        }
    }

    @Override
    public void testAssumptionFailure(Test test, Throwable throwable) {
        this.formatSkip(test, throwable.getMessage());
    }

    private void write(String text) {
        if (this.out == null) {
            return;
        }
        try {
            this.out.write(text.getBytes());
            this.out.flush();
        }
        catch (IOException ex) {
            throw new BuildException("Unable to write output " + ex, ex);
        }
    }
}

