/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarantlr4.runtime.misc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stats {
    public static final String ANTLRWORKS_DIR = "antlrworks";

    public static double stddev(int[] X) {
        int m3 = X.length;
        if (m3 <= 1) {
            return 0.0;
        }
        double xbar = Stats.avg(X);
        double s2 = 0.0;
        for (int i2 = 0; i2 < m3; ++i2) {
            s2 += ((double)X[i2] - xbar) * ((double)X[i2] - xbar);
        }
        return Math.sqrt(s2 /= (double)(m3 - 1));
    }

    public static double avg(int[] X) {
        double xbar = 0.0;
        int m3 = X.length;
        if (m3 == 0) {
            return 0.0;
        }
        for (int i2 = 0; i2 < m3; ++i2) {
            xbar += (double)X[i2];
        }
        if (xbar >= 0.0) {
            return xbar / (double)m3;
        }
        return 0.0;
    }

    public static int min(int[] X) {
        int min2 = Integer.MAX_VALUE;
        int m3 = X.length;
        if (m3 == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < m3; ++i2) {
            if (X[i2] >= min2) continue;
            min2 = X[i2];
        }
        return min2;
    }

    public static int max(int[] X) {
        int max = Integer.MIN_VALUE;
        int m3 = X.length;
        if (m3 == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < m3; ++i2) {
            if (X[i2] <= max) continue;
            max = X[i2];
        }
        return max;
    }

    public static double avg(List<Integer> X) {
        double xbar = 0.0;
        int m3 = X.size();
        if (m3 == 0) {
            return 0.0;
        }
        for (int i2 = 0; i2 < m3; ++i2) {
            xbar += (double)X.get(i2).intValue();
        }
        if (xbar >= 0.0) {
            return xbar / (double)m3;
        }
        return 0.0;
    }

    public static int min(List<Integer> X) {
        int min2 = Integer.MAX_VALUE;
        int m3 = X.size();
        if (m3 == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < m3; ++i2) {
            if (X.get(i2) >= min2) continue;
            min2 = X.get(i2);
        }
        return min2;
    }

    public static int max(List<Integer> X) {
        int max = Integer.MIN_VALUE;
        int m3 = X.size();
        if (m3 == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < m3; ++i2) {
            if (X.get(i2) <= max) continue;
            max = X.get(i2);
        }
        return max;
    }

    public static int sum(int[] X) {
        int s2 = 0;
        int m3 = X.length;
        if (m3 == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < m3; ++i2) {
            s2 += X[i2];
        }
        return s2;
    }

    public static void writeReport(String filename, String data) throws IOException {
        String absoluteFilename = Stats.getAbsoluteFileName(filename);
        File f = new File(absoluteFilename);
        File parent = f.getParentFile();
        parent.mkdirs();
        FileOutputStream fos = new FileOutputStream(f, true);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        PrintStream ps = new PrintStream(bos);
        ps.println(data);
        ps.close();
        bos.close();
        fos.close();
    }

    public static String getAbsoluteFileName(String filename) {
        return System.getProperty("user.home") + File.separator + ANTLRWORKS_DIR + File.separator + filename;
    }
}

