/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarantlr4.runtime;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitSet
implements Cloneable {
    protected static final int BITS = 64;
    protected static final int LOG_BITS = 6;
    protected static final int MOD_MASK = 63;
    protected long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(long[] bits_) {
        this.bits = bits_;
    }

    public BitSet(List<Integer> items) {
        this();
        for (int i2 = 0; i2 < items.size(); ++i2) {
            Integer v = items.get(i2);
            this.add(v);
        }
    }

    public BitSet(int nbits) {
        this.bits = new long[(nbits - 1 >> 6) + 1];
    }

    public static BitSet of(int el) {
        BitSet s2 = new BitSet(el + 1);
        s2.add(el);
        return s2;
    }

    public static BitSet of(int a, int b) {
        BitSet s2 = new BitSet(Math.max(a, b) + 1);
        s2.add(a);
        s2.add(b);
        return s2;
    }

    public static BitSet of(int a, int b, int c) {
        BitSet s2 = new BitSet();
        s2.add(a);
        s2.add(b);
        s2.add(c);
        return s2;
    }

    public static BitSet of(int a, int b, int c, int d) {
        BitSet s2 = new BitSet();
        s2.add(a);
        s2.add(b);
        s2.add(c);
        s2.add(d);
        return s2;
    }

    public BitSet or(BitSet a) {
        if (a == null) {
            return this;
        }
        BitSet s2 = (BitSet)this.clone();
        s2.orInPlace(a);
        return s2;
    }

    public void add(int el) {
        int n = BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            this.growToInclude(el);
        }
        int n2 = n;
        this.bits[n2] = this.bits[n2] | BitSet.bitMask(el);
    }

    public void growToInclude(int bit) {
        int newSize = Math.max(this.bits.length << 1, this.numWordsToHold(bit));
        long[] newbits = new long[newSize];
        System.arraycopy(this.bits, 0, newbits, 0, this.bits.length);
        this.bits = newbits;
    }

    public void orInPlace(BitSet a) {
        if (a == null) {
            return;
        }
        if (a.bits.length > this.bits.length) {
            this.setSize(a.bits.length);
        }
        int min2 = Math.min(this.bits.length, a.bits.length);
        for (int i2 = min2 - 1; i2 >= 0; --i2) {
            int n = i2;
            this.bits[n] = this.bits[n] | a.bits[i2];
        }
    }

    private void setSize(int nwords) {
        long[] newbits = new long[nwords];
        int n = Math.min(nwords, this.bits.length);
        System.arraycopy(this.bits, 0, newbits, 0, n);
        this.bits = newbits;
    }

    private static final long bitMask(int bitNumber) {
        int bitPosition = bitNumber & 0x3F;
        return 1L << bitPosition;
    }

    public Object clone() {
        BitSet s2;
        try {
            s2 = (BitSet)super.clone();
            s2.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, s2.bits, 0, this.bits.length);
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        return s2;
    }

    public int size() {
        int deg = 0;
        for (int i2 = this.bits.length - 1; i2 >= 0; --i2) {
            long word = this.bits[i2];
            if (word == 0L) continue;
            for (int bit = 63; bit >= 0; --bit) {
                if ((word & 1L << bit) == 0L) continue;
                ++deg;
            }
        }
        return deg;
    }

    public boolean equals(Object other) {
        block5: {
            int i2;
            int n;
            BitSet otherSet;
            block4: {
                if (other == null || !(other instanceof BitSet)) {
                    return false;
                }
                otherSet = (BitSet)other;
                n = Math.min(this.bits.length, otherSet.bits.length);
                for (i2 = 0; i2 < n; ++i2) {
                    if (this.bits[i2] == otherSet.bits[i2]) continue;
                    return false;
                }
                if (this.bits.length <= n) break block4;
                for (i2 = n + 1; i2 < this.bits.length; ++i2) {
                    if (this.bits[i2] == 0L) continue;
                    return false;
                }
                break block5;
            }
            if (otherSet.bits.length <= n) break block5;
            for (i2 = n + 1; i2 < otherSet.bits.length; ++i2) {
                if (otherSet.bits[i2] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean member(int el) {
        if (el < 0) {
            return false;
        }
        int n = BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            return false;
        }
        return (this.bits[n] & BitSet.bitMask(el)) != 0L;
    }

    public void remove(int el) {
        int n = BitSet.wordNumber(el);
        if (n < this.bits.length) {
            int n2 = n;
            this.bits[n2] = this.bits[n2] & (BitSet.bitMask(el) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public boolean isNil() {
        for (int i2 = this.bits.length - 1; i2 >= 0; --i2) {
            if (this.bits[i2] == 0L) continue;
            return false;
        }
        return true;
    }

    private final int numWordsToHold(int el) {
        return (el >> 6) + 1;
    }

    public int numBits() {
        return this.bits.length << 6;
    }

    public int lengthInLongWords() {
        return this.bits.length;
    }

    public int[] toArray() {
        int[] elems = new int[this.size()];
        int en = 0;
        for (int i2 = 0; i2 < this.bits.length << 6; ++i2) {
            if (!this.member(i2)) continue;
            elems[en++] = i2;
        }
        return elems;
    }

    public long[] toPackedArray() {
        return this.bits;
    }

    private static final int wordNumber(int bit) {
        return bit >> 6;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String[] tokenNames) {
        StringBuilder buf = new StringBuilder();
        String separator = ",";
        boolean havePrintedAnElement = false;
        buf.append('{');
        for (int i2 = 0; i2 < this.bits.length << 6; ++i2) {
            if (!this.member(i2)) continue;
            if (i2 > 0 && havePrintedAnElement) {
                buf.append(separator);
            }
            if (tokenNames != null) {
                buf.append(tokenNames[i2]);
            } else {
                buf.append(i2);
            }
            havePrintedAnElement = true;
        }
        buf.append('}');
        return buf.toString();
    }
}

