/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.gradlestaticanalyzer.internal.services;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;

public class BuildFileCache {
    private static final HashFunction HASH_FUNCTION = Hashing.md5();
    private final Map<String, List<ASTNode>> cache = new HashMap<String, List<ASTNode>>();

    public List<ASTNode> getBuildFileNodes(String content) {
        return this.cache.get(this.getHashCodeForBuildFileContent(content));
    }

    public List<ASTNode> putBuildFileNodes(String content, List<ASTNode> nodes) {
        return this.cache.put(this.getHashCodeForBuildFileContent(content), nodes);
    }

    private String getHashCodeForBuildFileContent(String content) {
        return HASH_FUNCTION.hashString((CharSequence)content, StandardCharsets.UTF_8).toString();
    }
}

