/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.gradlestaticanalyzer.internal.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.kronicle.gradlestaticanalyzer.internal.services.Downloader;
import tech.kronicle.gradlestaticanalyzer.internal.services.RepositoryAuthHeadersRegistry;
import tech.kronicle.gradlestaticanalyzer.internal.utils.ArtifactUtils;
import tech.kronicle.sdk.models.SoftwareRepository;

public class MavenRepositoryFileDownloader {
    private static final Logger log = LoggerFactory.getLogger(MavenRepositoryFileDownloader.class);
    private static final int MAX_REDIRECT_COUNT = 1;
    private final ArtifactUtils artifactUtils;
    private final Downloader downloader;
    private final RepositoryAuthHeadersRegistry repositoryAuthHeadersRegistry;

    public MavenFileRequestOutcome<String> downloadArtifact(String artifactCoordinates, String packaging, Set<SoftwareRepository> softwareRepositories) {
        return this.downloadMavenRepositoryFile(this.getArtifactPath(artifactCoordinates, packaging), softwareRepositories);
    }

    public MavenFileRequestOutcome<Boolean> checkArtifactExists(String artifactCoordinates, String packaging, Set<SoftwareRepository> softwareRepositories) {
        return this.checkMavenRepositoryFileExists(this.getArtifactPath(artifactCoordinates, packaging), softwareRepositories);
    }

    public MavenFileRequestOutcome<String> downloadMetadata(String groupId, String artifactId, Set<SoftwareRepository> softwareRepositories) {
        return this.downloadMavenRepositoryFile(this.getMetadataPath(groupId, artifactId), softwareRepositories);
    }

    private MavenFileRequestOutcome<String> downloadMavenRepositoryFile(String filePath, Set<SoftwareRepository> softwareRepositories) {
        return this.makeMavenRepositoryFileRequest(filePath, softwareRepositories, url -> this.downloader.download((String)url, this.repositoryAuthHeadersRegistry.getRepositoryAuthHeaders((String)url), 1));
    }

    private MavenFileRequestOutcome<Boolean> checkMavenRepositoryFileExists(String filePath, Set<SoftwareRepository> softwareRepositories) {
        return this.makeMavenRepositoryFileRequest(filePath, softwareRepositories, url -> this.downloader.exists((String)url, this.repositoryAuthHeadersRegistry.getRepositoryAuthHeaders((String)url), 1));
    }

    private <T> MavenFileRequestOutcome<T> makeMavenRepositoryFileRequest(String filePath, Set<SoftwareRepository> softwareRepositories, Function<String, Downloader.HttpRequestOutcome<T>> downloadMaker) {
        List<String> safeRepositoryUrls = this.getSafeSoftwareRepositoryUrls(softwareRepositories);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (String repositoryUrl : safeRepositoryUrls) {
            Downloader.HttpRequestOutcome<T> output = downloadMaker.apply(repositoryUrl + filePath);
            if (output.isSuccess()) {
                return MavenFileRequestOutcome.from(output);
            }
            exceptions.addAll(output.getExceptions());
        }
        return new MavenFileRequestOutcome<Object>(null, false, null, exceptions);
    }

    private List<String> getSafeSoftwareRepositoryUrls(Set<SoftwareRepository> softwareRepositories) {
        List<String> list = softwareRepositories.stream().filter(SoftwareRepository::getSafe).map(softwareRepository -> softwareRepository.getUrl().replaceAll("/+$", "")).collect(Collectors.toList());
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No safe repositories configured");
        }
        return list;
    }

    private String getArtifactPath(String artifact, String packaging) {
        ArtifactUtils.ArtifactParts artifactParts = this.artifactUtils.getArtifactParts(artifact);
        return this.getArtifactPath(artifactParts.getGroupId(), artifactParts.getArtifactId(), artifactParts.getVersion(), packaging);
    }

    private String getArtifactPath(String groupId, String artifactId, String version, String packaging) {
        return this.getGroupIdAndArtifactIdPath(groupId, artifactId) + version + "/" + artifactId + "-" + version + "." + packaging;
    }

    private String getMetadataPath(String groupId, String artifactId) {
        return this.getGroupIdAndArtifactIdPath(groupId, artifactId) + "maven-metadata.xml";
    }

    private String getGroupIdAndArtifactIdPath(String groupId, String artifactId) {
        return this.getGroupIdPath(groupId) + "/" + artifactId + "/";
    }

    private String getGroupIdPath(String groupId) {
        return "/" + groupId.replaceAll("\\.", "/");
    }

    public MavenRepositoryFileDownloader(ArtifactUtils artifactUtils, Downloader downloader, RepositoryAuthHeadersRegistry repositoryAuthHeadersRegistry) {
        this.artifactUtils = artifactUtils;
        this.downloader = downloader;
        this.repositoryAuthHeadersRegistry = repositoryAuthHeadersRegistry;
    }

    public static final class MavenFileRequestOutcome<T> {
        private final String url;
        private final boolean success;
        private final T output;
        private final List<Exception> exceptions;

        public boolean isFailure() {
            return !this.success;
        }

        public static <T> MavenFileRequestOutcome<T> from(Downloader.HttpRequestOutcome<T> value) {
            return new MavenFileRequestOutcome<T>(value.getUrl(), value.isSuccess(), value.getOutput(), value.getExceptions());
        }

        public MavenFileRequestOutcome(String url, boolean success, T output, List<Exception> exceptions) {
            this.url = url;
            this.success = success;
            this.output = output;
            this.exceptions = exceptions;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public T getOutput() {
            return this.output;
        }

        public List<Exception> getExceptions() {
            return this.exceptions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MavenFileRequestOutcome)) {
                return false;
            }
            MavenFileRequestOutcome other = (MavenFileRequestOutcome)o;
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            T this$output = this.getOutput();
            T other$output = other.getOutput();
            if (this$output == null ? other$output != null : !this$output.equals(other$output)) {
                return false;
            }
            List<Exception> this$exceptions = this.getExceptions();
            List<Exception> other$exceptions = other.getExceptions();
            return !(this$exceptions == null ? other$exceptions != null : !((Object)this$exceptions).equals(other$exceptions));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            T $output = this.getOutput();
            result = result * 59 + ($output == null ? 43 : $output.hashCode());
            List<Exception> $exceptions = this.getExceptions();
            result = result * 59 + ($exceptions == null ? 43 : ((Object)$exceptions).hashCode());
            return result;
        }

        public String toString() {
            return "MavenRepositoryFileDownloader.MavenFileRequestOutcome(url=" + this.getUrl() + ", success=" + this.isSuccess() + ", output=" + this.getOutput() + ", exceptions=" + this.getExceptions() + ")";
        }
    }
}

