/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.buildgradlevisitor;

import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.BaseBuildFileVisitor;
import tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.BaseBuildFileVisitorDependencies;
import tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.ExpressionVisitOutcome;

public class MicronautVisitor
extends BaseBuildFileVisitor {
    private static final Logger log = LoggerFactory.getLogger(MicronautVisitor.class);

    public MicronautVisitor(BaseBuildFileVisitorDependencies dependencies) {
        super(dependencies);
    }

    @Override
    protected Logger log() {
        return log;
    }

    @Override
    protected ExpressionVisitOutcome processMethodCallExpression(MethodCallExpression call) {
        if (call.getMethodAsString().equals("version")) {
            ArgumentListExpression arguments;
            log.debug("Found micronaut version");
            if (call.getArguments() instanceof ArgumentListExpression && (arguments = (ArgumentListExpression)call.getArguments()).getExpressions().size() == 1) {
                this.visitorState().getProperties().put("micronautVersion", arguments.getExpression(0).getText());
                return ExpressionVisitOutcome.PROCESSED;
            }
            throw new RuntimeException("Unexpected format of version in micronaut block");
        }
        return ExpressionVisitOutcome.IGNORED;
    }
}

