/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.gradlestaticanalyzer.internal.services;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import tech.kronicle.gradlestaticanalyzer.config.GradleConfig;
import tech.kronicle.gradlestaticanalyzer.config.HttpHeaderConfig;

public class RepositoryAuthHeadersRegistry {
    private final Map<String, List<HttpHeaderConfig>> customRepositories;

    public RepositoryAuthHeadersRegistry(GradleConfig config) {
        this.customRepositories = Optional.ofNullable(config.getCustomRepositories()).orElse(List.of()).stream().collect(Collectors.toUnmodifiableMap(it -> RepositoryAuthHeadersRegistry.ensureUrlHasATrailingSlash(it.getUrl()), gradleCustomRepository -> Optional.ofNullable(gradleCustomRepository.getHttpHeaders()).orElse(List.of())));
    }

    public List<HttpHeaderConfig> getRepositoryAuthHeaders(String url) {
        return this.customRepositories.entrySet().stream().filter(it -> url.startsWith((String)it.getKey())).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    private static String ensureUrlHasATrailingSlash(String url) {
        return url.endsWith("/") ? url : url + "/";
    }
}

