/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.plugins.gradle.internal.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.kronicle.common.StringEscapeUtils;
import tech.kronicle.plugins.gradle.internal.models.Pom;
import tech.kronicle.plugins.gradle.internal.models.PomOutcome;
import tech.kronicle.plugins.gradle.internal.models.mavenxml.DependenciesContainer;
import tech.kronicle.plugins.gradle.internal.models.mavenxml.Project;
import tech.kronicle.plugins.gradle.internal.models.mavenxml.ProjectCoordinates;
import tech.kronicle.plugins.gradle.internal.models.mavenxml.project.Dependencies;
import tech.kronicle.plugins.gradle.internal.models.mavenxml.project.Dependency;
import tech.kronicle.plugins.gradle.internal.models.mavenxml.project.Parent;
import tech.kronicle.plugins.gradle.internal.models.mavenxml.project.Properties;
import tech.kronicle.plugins.gradle.internal.services.MavenRepositoryFileDownloader;
import tech.kronicle.plugins.gradle.internal.services.PomCache;
import tech.kronicle.plugins.gradle.internal.services.PropertyExpander;
import tech.kronicle.plugins.gradle.internal.utils.ArtifactUtils;
import tech.kronicle.plugins.gradle.internal.utils.JaxbUnmarshallerFactory;
import tech.kronicle.plugins.gradle.internal.utils.XmlInputFactoryFactory;
import tech.kronicle.sdk.models.Software;
import tech.kronicle.sdk.models.SoftwareDependencyType;
import tech.kronicle.sdk.models.SoftwareRepository;
import tech.kronicle.sdk.models.SoftwareType;
import tech.kronicle.utils.StringUtils;

public class PomFetcher {
    private static final Logger log = LoggerFactory.getLogger(PomFetcher.class);
    private final MavenRepositoryFileDownloader mavenRepositoryFileDownloader;
    private final PomCache pomCache;
    private final PropertyExpander propertyExpander;
    private final ObjectMapper objectMapper;
    private final ArtifactUtils artifactUtils;
    private final Unmarshaller unmarshaller = JaxbUnmarshallerFactory.createJaxbUnmarshaller(Project.class);
    private final XMLInputFactory xmlInputFactory = XmlInputFactoryFactory.createXmlInputFactory();

    public PomOutcome fetchPom(String pomArtifactCoordinates, Set<SoftwareRepository> softwareRepositories) {
        Pom pom;
        log.debug("Processing POM \"" + StringEscapeUtils.escapeString((String)pomArtifactCoordinates) + "\"");
        log.debug("Downloading and processing POM");
        MavenRepositoryFileDownloader.MavenFileRequestOutcome<String> xmlContent = this.mavenRepositoryFileDownloader.downloadArtifact(pomArtifactCoordinates, "pom", softwareRepositories);
        if (xmlContent.isFailure()) {
            if (!xmlContent.getExceptions().isEmpty()) {
                throw new IllegalArgumentException("Error with retrieving POM artifact \"" + StringEscapeUtils.escapeString((String)pomArtifactCoordinates) + "\"", this.getFirstException(xmlContent.getExceptions()));
            }
            MavenRepositoryFileDownloader.MavenFileRequestOutcome<Boolean> exists = this.mavenRepositoryFileDownloader.checkArtifactExists(pomArtifactCoordinates, "jar", softwareRepositories);
            if (exists.isFailure()) {
                throw new IllegalArgumentException("Error with checking existence of JAR artifact \"" + StringEscapeUtils.escapeString((String)pomArtifactCoordinates) + "\"", this.getFirstException(exists.getExceptions()));
            }
            if (exists.getOutput().booleanValue()) {
                return PomOutcome.builder().jarOnly(true).build();
            }
            throw new IllegalArgumentException("Could not retrieve POM artifact \"" + StringEscapeUtils.escapeString((String)pomArtifactCoordinates) + "\" from safe subset of configured repositories");
        }
        Optional<String> jsonContent = this.pomCache.get(xmlContent.getUrl());
        if (jsonContent.isPresent()) {
            log.debug("Found cached copy of POM");
            pom = this.readPomJson(jsonContent.get());
        } else {
            Project project = this.readPomXml(xmlContent.getOutput());
            pom = this.fetchPom(pomArtifactCoordinates, project, softwareRepositories);
            jsonContent = Optional.of(this.writePomJson(pom));
            this.pomCache.put(xmlContent.getUrl(), jsonContent.get());
        }
        log.debug("Found {} software items", (Object)(Objects.nonNull(pom.getDependencyManagementDependencies()) ? pom.getDependencyManagementDependencies().size() : 0));
        return PomOutcome.builder().jarOnly(false).pom(pom).build();
    }

    private Exception getFirstException(List<Exception> exceptions) {
        return exceptions.isEmpty() ? null : exceptions.get(0);
    }

    protected Pom readPomJson(String content) {
        try {
            return (Pom)this.objectMapper.readValue(content, Pom.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not read POM JSON", e);
        }
    }

    private String writePomJson(Pom pom) {
        try {
            return this.objectMapper.writeValueAsString((Object)pom);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not write POM JSON", e);
        }
    }

    private Project readPomXml(String content) {
        try {
            return (Project)this.unmarshaller.unmarshal(this.xmlInputFactory.createXMLStreamReader(new StringReader(content)));
        }
        catch (JAXBException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private Pom fetchPom(String pomArtifactCoordinates, Project project, Set<SoftwareRepository> softwareRepositories) {
        Pom.PomBuilder pomBuilder = Pom.builder().artifactCoordinates(pomArtifactCoordinates);
        HashMap<String, String> properties = new HashMap<String, String>();
        Parent parent = project.getParent();
        if (Objects.nonNull(parent)) {
            String parentArtifactCoordinates = this.artifactUtils.createArtifact(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
            Optional<Pom> parentPom = this.processRelatedPom(pomBuilder, parentArtifactCoordinates, softwareRepositories);
            if (parentPom.isEmpty()) {
                throw new IllegalArgumentException("Could not retrieve parent POM \"" + StringEscapeUtils.escapeString((String)parentArtifactCoordinates) + "\" from safe subset of configured repositories");
            }
            properties.putAll(parentPom.get().getProperties());
        }
        this.addProperties(properties, project);
        pomBuilder.properties(properties);
        Pom temporaryPom = pomBuilder.build();
        this.processDependencies(Optional.of(project).map(Project::getDependencyManagement), DependencyType.DEPENDENCY_MANAGEMENT, softwareRepositories, temporaryPom, pomBuilder);
        temporaryPom = pomBuilder.build();
        this.processDependencies(Optional.of(project), DependencyType.NORMAL, softwareRepositories, temporaryPom, pomBuilder);
        return pomBuilder.build();
    }

    private void processDependencies(Optional<DependenciesContainer> dependenciesContainer, DependencyType dependencyType, Set<SoftwareRepository> softwareRepositories, Pom pom, Pom.PomBuilder pomBuilder) {
        dependenciesContainer.map(DependenciesContainer::getDependencies).map(Dependencies::getDependencies).ifPresent(dependencies -> dependencies.forEach(dependency -> this.processDependency((Dependency)dependency, dependencyType, softwareRepositories, pom, pomBuilder)));
    }

    private void processDependency(Dependency dependency, DependencyType dependencyType, Set<SoftwareRepository> softwareRepositories, Pom pom, Pom.PomBuilder pomBuilder) {
        List<String> versions;
        String groupId = this.getNonEmptyElementWithPropertyExpansion("groupId", dependency.getGroupId(), pom);
        String artifactId = this.getNonEmptyElementWithPropertyExpansion("artifactId", dependency.getArtifactId(), pom);
        String type = this.requireNoPropertyReferences("type", dependency.getType());
        String scope = this.requireNoPropertyReferences("scope", dependency.getScope());
        if (Objects.nonNull(dependency.getVersion()) && !dependency.getVersion().isEmpty()) {
            String version2 = this.getNonEmptyElementWithPropertyExpansion("version", dependency.getVersion(), pom);
            versions = List.of(version2);
        } else {
            String name = this.artifactUtils.createName(groupId, artifactId);
            versions = pom.getDependencyManagementDependencies().stream().filter(item -> Objects.equals(item.getName(), name)).map(Software::getVersion).collect(Collectors.toList());
            if (versions.isEmpty()) {
                throw new RuntimeException("Could not find version for dependency \"" + StringEscapeUtils.escapeString((String)name) + "\"");
            }
        }
        versions.forEach(version -> {
            String relatedPomArtifact = this.artifactUtils.createArtifact(groupId, artifactId, (String)version);
            if (Objects.nonNull(scope) && Objects.equals(scope, "import")) {
                if (dependencyType == DependencyType.NORMAL) {
                    throw new UnsupportedOperationException("Import is not supported for a normal dependency");
                }
                Objects.requireNonNull(type, "type");
                if (!type.equals("pom")) {
                    throw new UnsupportedOperationException("Unexpected type \"" + StringEscapeUtils.escapeString((String)type) + "\"");
                }
                this.processRelatedPom(pomBuilder, relatedPomArtifact, softwareRepositories);
            } else {
                Software software = Software.builder().type(SoftwareType.JVM).dependencyType(SoftwareDependencyType.TRANSITIVE).name(this.artifactUtils.createName(groupId, artifactId)).version(version).build();
                if (dependencyType == DependencyType.NORMAL) {
                    pomBuilder.dependency(software);
                } else {
                    pomBuilder.dependencyManagementDependency(software);
                }
            }
        });
    }

    private Optional<Pom> processRelatedPom(Pom.PomBuilder pomBuilder, String relatedPomArtifact, Set<SoftwareRepository> softwareRepositories) {
        PomOutcome pomOutcome = this.fetchPom(relatedPomArtifact, softwareRepositories);
        if (pomOutcome.isJarOnly()) {
            return Optional.empty();
        }
        Pom relatedPom = pomOutcome.getPom();
        pomBuilder.transitiveArtifactCoordinates(relatedPom.getArtifactCoordinates());
        if (Objects.nonNull(relatedPom.getTransitiveArtifactCoordinates())) {
            pomBuilder.transitiveArtifactCoordinates(relatedPom.getTransitiveArtifactCoordinates());
        }
        if (Objects.nonNull(relatedPom.getDependencyManagementDependencies())) {
            pomBuilder.dependencyManagementDependencies(relatedPom.getDependencyManagementDependencies());
        }
        if (Objects.nonNull(relatedPom.getDependencies())) {
            pomBuilder.dependencies(relatedPom.getDependencies());
        }
        return Optional.of(relatedPom);
    }

    private String getNonEmptyElementWithPropertyExpansion(String name, String value, Pom pom) {
        return StringUtils.requireNonEmpty((String)this.expandProperties(name, value, pom), (String)name);
    }

    private String expandProperties(String name, String value, Pom pom) {
        return this.propertyExpander.expandProperties(value, name, pom.getProperties(), true);
    }

    private String requireNoPropertyReferences(String name, String value) {
        if (Objects.nonNull(value) && value.contains("$")) {
            throw new UnsupportedOperationException(name + " with value \"" + StringEscapeUtils.escapeString((String)value) + "\" not expected to contain property references");
        }
        return value;
    }

    private void addProperties(Map<String, String> properties, Project project) {
        Optional.of(project).map(Project::getProperties).map(Properties::getProperties).ifPresent(propertyElements -> propertyElements.forEach(propertyElement -> properties.put(propertyElement.getLocalName(), propertyElement.getTextContent())));
        properties.put("project.groupId", this.getProjectValue(project, "groupId", ProjectCoordinates::getGroupId));
        properties.put("project.version", this.getProjectValue(project, "version", ProjectCoordinates::getVersion));
    }

    private String getProjectValue(Project project, String name, Function<ProjectCoordinates, String> valueGetter) {
        Optional<String> projectValue = Optional.of(project).map(valueGetter);
        if (projectValue.isEmpty() && (projectValue = Optional.of(project.getParent()).map(valueGetter)).isEmpty()) {
            throw new IllegalArgumentException("POM does not contain project " + name);
        }
        return projectValue.get();
    }

    public PomFetcher(MavenRepositoryFileDownloader mavenRepositoryFileDownloader, PomCache pomCache, PropertyExpander propertyExpander, ObjectMapper objectMapper, ArtifactUtils artifactUtils) {
        this.mavenRepositoryFileDownloader = mavenRepositoryFileDownloader;
        this.pomCache = pomCache;
        this.propertyExpander = propertyExpander;
        this.objectMapper = objectMapper;
        this.artifactUtils = artifactUtils;
    }

    private static enum DependencyType {
        DEPENDENCY_MANAGEMENT,
        NORMAL;

    }
}

