/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.plugins.gradle.internal.services;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.kronicle.plugins.gradle.internal.models.Import;
import tech.kronicle.plugins.gradle.internal.services.ImportResolver;
import tech.kronicle.plugins.gradle.internal.services.PropertyExpander;
import tech.kronicle.plugins.gradle.internal.services.PropertyRetriever;

public class ExpressionEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ExpressionEvaluator.class);
    private final PropertyExpander propertyExpander;
    private final PropertyRetriever propertyRetriever;
    private final ImportResolver importResolver;

    public String evaluateExpression(Expression expression, Map<String, String> properties, Set<Import> imports) {
        if (expression instanceof ConstantExpression) {
            return expression.getText();
        }
        if (expression instanceof GStringExpression) {
            return this.propertyExpander.expandProperties(expression.getText(), "expression", properties, false);
        }
        if (expression instanceof VariableExpression) {
            String name = expression.getText();
            if (Objects.equals(name, "buildscript")) {
                return name;
            }
            Import importItem = this.importResolver.importResolver(name, imports);
            if (Objects.nonNull(importItem)) {
                return importItem.getClassName();
            }
            return this.propertyRetriever.getPropertyValue(name, properties);
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binary = (BinaryExpression)expression;
            String operationText = binary.getOperation().getText();
            if (operationText.equals("+")) {
                return this.evaluateExpression(binary.getLeftExpression(), properties, imports) + this.evaluateExpression(binary.getRightExpression(), properties, imports);
            }
            log.debug("Ignored binary expression with operation \"" + operationText + "\"");
            return null;
        }
        if (expression instanceof PropertyExpression) {
            return expression.getText();
        }
        log.debug("Ignored binary expression of type \"" + expression.getClass().getName() + "\"");
        return null;
    }

    public ExpressionEvaluator(PropertyExpander propertyExpander, PropertyRetriever propertyRetriever, ImportResolver importResolver) {
        this.propertyExpander = propertyExpander;
        this.propertyRetriever = propertyRetriever;
        this.importResolver = importResolver;
    }
}

