/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.plugins.gradle.internal.services;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.kronicle.common.StringEscapeUtils;
import tech.kronicle.plugins.gradle.config.DownloaderConfig;
import tech.kronicle.plugins.gradle.config.HttpHeaderConfig;
import tech.kronicle.plugins.gradle.internal.services.DownloadCache;
import tech.kronicle.plugins.gradle.internal.services.DownloaderException;
import tech.kronicle.plugins.gradle.internal.services.HttpRequestMaker;
import tech.kronicle.plugins.gradle.internal.services.UrlExistsCache;
import tech.kronicle.utils.HttpClientFactory;

public class Downloader {
    private static final Logger log = LoggerFactory.getLogger(Downloader.class);
    private final HttpClient httpClient;
    private final DownloaderConfig config;
    private final DownloadCache downloadCache;
    private final UrlExistsCache urlExistsCache;
    private final HttpRequestMaker httpRequestMaker;

    public HttpRequestOutcome<String> download(String url, List<HttpHeaderConfig> headers, int maxRedirectCount) {
        log.debug("Downloading from URL \"" + StringEscapeUtils.escapeString((String)url) + "\"");
        return this.makeRequestFollowingRedirects("GET", url, maxRedirectCount, originalUrlOrRedirectUrl -> this.makeRequest(HttpClientFactory.createHttpRequestBuilder((Duration)this.config.getTimeout()), (String)originalUrlOrRedirectUrl, headers), response -> response.statusCode() == 200 ? Optional.ofNullable((String)response.body()) : Optional.empty(), this.downloadCache::getContent, this.downloadCache::putContent);
    }

    private HttpResponse<String> makeRequest(HttpRequest.Builder requestBuilder, String originalUrlOrRedirectUrl, List<HttpHeaderConfig> headers) {
        this.addHeaders(requestBuilder.uri(URI.create(originalUrlOrRedirectUrl)), headers);
        return this.httpClient.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
    }

    private void addHeaders(HttpRequest.Builder requestBuilder, List<HttpHeaderConfig> headers) {
        if (Objects.nonNull(headers) && !headers.isEmpty()) {
            headers.forEach(header -> requestBuilder.header(header.getName(), header.getValue()));
        }
    }

    public HttpRequestOutcome<Boolean> exists(String url, List<HttpHeaderConfig> headers, int maxRedirectCount) {
        log.debug("Checking whether URL \"" + StringEscapeUtils.escapeString((String)url) + "\" exists");
        return this.makeRequestFollowingRedirects("HEAD", url, maxRedirectCount, originalUrlOrRedirectUrl -> this.makeRequest(HttpClientFactory.createHttpRequestBuilder((Duration)this.config.getTimeout()).method("HEAD", HttpRequest.BodyPublishers.noBody()), (String)originalUrlOrRedirectUrl, headers), response -> {
            if (response.statusCode() == 200) {
                return Optional.of(true);
            }
            if (response.statusCode() == 404) {
                return Optional.of(false);
            }
            return Optional.empty();
        }, this.urlExistsCache::getExists, this.urlExistsCache::putExists);
    }

    private <T> HttpRequestOutcome<T> makeRequestFollowingRedirects(String httpMethod, String url, int maxRedirectCount, Function<String, HttpResponse<String>> httpRequest, Function<HttpResponse<String>, Optional<T>> outputGetter, Function<String, Optional<T>> cacheGetter, BiConsumer<String, T> cacheSetter) {
        block9: {
            int statusCode;
            HttpResponse<String> response;
            Optional<T> output;
            block7: {
                block8: {
                    output = cacheGetter.apply(url);
                    if (output.isPresent()) {
                        log.debug("Entry found in cache");
                        return new HttpRequestOutcome<T>(url, true, output.get(), List.of());
                    }
                    int redirectCount = 0;
                    do {
                        try {
                            response = this.httpRequestMaker.makeHttpRequest(httpRequest, url);
                        }
                        catch (Exception e) {
                            log.error("Failed to make HTTP request for URL \"{}\"", (Object)StringEscapeUtils.escapeString((String)url), (Object)e);
                            return new HttpRequestOutcome<Object>(url, false, null, List.of(e));
                        }
                        log.debug("Response status code was " + response.statusCode());
                        statusCode = response.statusCode();
                        if (statusCode != 301 && statusCode != 302 && statusCode != 303) break block7;
                        if (++redirectCount > maxRedirectCount) break block8;
                        url = this.getLocationHeader(response);
                        if (!Objects.isNull(url)) continue;
                        log.warn("Redirect response is missing a Location HTTP response header");
                        break block9;
                    } while (!(output = cacheGetter.apply(url)).isPresent());
                    log.debug("Entry found in cache");
                    return new HttpRequestOutcome<T>(url, true, output.get(), List.of());
                }
                log.info("Exceeded max redirect count for URL \"{}\"", (Object)StringEscapeUtils.escapeString((String)url));
                break block9;
            }
            if (statusCode == 200 || statusCode == 404) {
                output = outputGetter.apply(response);
                if (output.isPresent()) {
                    cacheSetter.accept(url, (String)output.get());
                    log.debug("Request succeeded");
                    return new HttpRequestOutcome<T>(url, true, output.get(), List.of());
                }
            } else {
                DownloaderException exception = new DownloaderException(httpMethod, url, statusCode, response.body());
                log.warn(exception.getMessage());
                return new HttpRequestOutcome<Object>(url, false, null, List.of(exception));
            }
        }
        log.debug("Request failed");
        return new HttpRequestOutcome<Object>(url, false, null, List.of());
    }

    private String getLocationHeader(HttpResponse<String> response) {
        return response.headers().firstValue("Location").orElse(null);
    }

    public Downloader(HttpClient httpClient, DownloaderConfig config, DownloadCache downloadCache, UrlExistsCache urlExistsCache, HttpRequestMaker httpRequestMaker) {
        this.httpClient = httpClient;
        this.config = config;
        this.downloadCache = downloadCache;
        this.urlExistsCache = urlExistsCache;
        this.httpRequestMaker = httpRequestMaker;
    }

    public static final class HttpRequestOutcome<T> {
        private final String url;
        private final boolean success;
        private final T output;
        private final List<Exception> exceptions;

        public boolean isFailure() {
            return !this.success;
        }

        public HttpRequestOutcome(String url, boolean success, T output, List<Exception> exceptions) {
            this.url = url;
            this.success = success;
            this.output = output;
            this.exceptions = exceptions;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public T getOutput() {
            return this.output;
        }

        public List<Exception> getExceptions() {
            return this.exceptions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpRequestOutcome)) {
                return false;
            }
            HttpRequestOutcome other = (HttpRequestOutcome)o;
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            T this$output = this.getOutput();
            T other$output = other.getOutput();
            if (this$output == null ? other$output != null : !this$output.equals(other$output)) {
                return false;
            }
            List<Exception> this$exceptions = this.getExceptions();
            List<Exception> other$exceptions = other.getExceptions();
            return !(this$exceptions == null ? other$exceptions != null : !((Object)this$exceptions).equals(other$exceptions));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            T $output = this.getOutput();
            result = result * 59 + ($output == null ? 43 : $output.hashCode());
            List<Exception> $exceptions = this.getExceptions();
            result = result * 59 + ($exceptions == null ? 43 : ((Object)$exceptions).hashCode());
            return result;
        }

        public String toString() {
            return "Downloader.HttpRequestOutcome(url=" + this.getUrl() + ", success=" + this.isSuccess() + ", output=" + this.getOutput() + ", exceptions=" + this.getExceptions() + ")";
        }
    }
}

