/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.plugins.gradle.internal.services;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.BaseVisitor;
import tech.kronicle.plugins.gradle.internal.models.Import;

public class BuildFileProcessor {
    public Set<Import> getImports(List<ASTNode> nodes) {
        HashSet<Import> imports = new HashSet<Import>();
        nodes.forEach(node -> {
            if (this.isClassNode((ASTNode)node)) {
                ClassNode classNode = (ClassNode)node;
                classNode.getModule().getImports().forEach(importNode -> {
                    if (!importNode.isStar() && !importNode.isStatic()) {
                        imports.add(new Import(importNode.getClassName(), importNode.getAlias()));
                    }
                });
            }
        });
        return imports;
    }

    public void visitNodes(List<ASTNode> nodes, BaseVisitor visitor) {
        nodes.forEach(node -> {
            if (!this.isClassNode((ASTNode)node)) {
                node.visit((GroovyCodeVisitor)visitor);
            }
        });
    }

    private boolean isClassNode(ASTNode node) {
        return node instanceof ClassNode;
    }
}

