/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.buildgradlevisitor;

import java.util.Objects;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.BaseVisitor;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.ExpressionVisitOutcome;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.buildgradlevisitor.BaseVisitorDependencies;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.buildgradlevisitor.MavenRepositoryVisitor;
import tech.kronicle.plugins.gradle.internal.services.CustomRepositoryRegistry;

public class RepositoriesVisitor
extends BaseVisitor {
    private static final Logger log = LoggerFactory.getLogger(RepositoriesVisitor.class);
    private final MavenRepositoryVisitor mavenRepositoryVisitor;
    private final CustomRepositoryRegistry customRepositoryRegistry;

    public RepositoriesVisitor(BaseVisitorDependencies dependencies, MavenRepositoryVisitor mavenRepositoryVisitor, CustomRepositoryRegistry customRepositoryRegistry) {
        super(dependencies);
        this.mavenRepositoryVisitor = mavenRepositoryVisitor;
        this.customRepositoryRegistry = customRepositoryRegistry;
    }

    @Override
    protected Logger log() {
        return log;
    }

    @Override
    protected ExpressionVisitOutcome processMethodCallExpression(MethodCallExpression call) {
        String methodName = call.getMethodAsString();
        if (methodName.equals("maven")) {
            this.visit(call.getArguments(), this.mavenRepositoryVisitor);
            return ExpressionVisitOutcome.PROCESSED;
        }
        String url = this.getRepositoryUrl(methodName);
        if (Objects.nonNull(url)) {
            this.addSoftwareRepository(url);
            return ExpressionVisitOutcome.PROCESSED;
        }
        return ExpressionVisitOutcome.IGNORED;
    }

    private String getRepositoryUrl(String methodName) {
        if (methodName.equals("gradlePluginPortal")) {
            return "https://plugins.gradle.org/m2/";
        }
        if (methodName.equals("mavenCentral")) {
            return "https://repo.maven.apache.org/maven2/";
        }
        if (methodName.equals("jcenter")) {
            return "https://jcenter.bintray.com/";
        }
        if (methodName.equals("google")) {
            return "https://dl.google.com/dl/android/maven2/";
        }
        return this.customRepositoryRegistry.getCustomRepositoryUrl(methodName);
    }
}

