/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.buildgradlevisitor;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.BaseVisitor;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.ExpressionVisitOutcome;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.buildgradlevisitor.BaseVisitorDependencies;
import tech.kronicle.plugins.gradle.internal.services.PluginProcessor;

public class PluginsVisitor
extends BaseVisitor {
    private static final Logger log = LoggerFactory.getLogger(PluginsVisitor.class);
    private final PluginProcessor pluginProcessor;

    public PluginsVisitor(BaseVisitorDependencies dependencies, PluginProcessor pluginProcessor) {
        super(dependencies);
        this.pluginProcessor = pluginProcessor;
    }

    @Override
    protected Logger log() {
        return log;
    }

    @Override
    protected ExpressionVisitOutcome processMethodCallExpression(MethodCallExpression call) {
        if (call.getMethodAsString().equals("id")) {
            this.processPlugin(call);
            return ExpressionVisitOutcome.PROCESSED;
        }
        if (call.getMethodAsString().equals("version")) {
            this.processPlugin(call);
            return ExpressionVisitOutcome.PROCESSED;
        }
        if (call.getMethodAsString().equals("apply")) {
            this.processPlugin(call);
            return ExpressionVisitOutcome.PROCESSED;
        }
        return ExpressionVisitOutcome.IGNORED;
    }

    private void processPlugin(MethodCallExpression call) {
        Map<String, String> values = this.getValues(call);
        String name = values.get("id");
        String version = values.get("version");
        boolean apply = this.getApplyValue(values);
        this.pluginProcessor.processPlugin(name, version, apply, this.visitorState().getSoftware());
    }

    private boolean getApplyValue(Map<String, String> values) {
        String text = values.get("apply");
        if (Objects.isNull(text) || Objects.equals(text, "true")) {
            return true;
        }
        if (Objects.equals(text, "false")) {
            return false;
        }
        throw new RuntimeException(String.format("Unexpected value \"%s\" for apply argument to plugin call", text));
    }

    private Map<String, String> getValues(MethodCallExpression call) {
        HashMap<String, String> values = new HashMap<String, String>();
        do {
            this.addValue(values, call);
        } while (Objects.nonNull(call = call.getObjectExpression() instanceof MethodCallExpression ? (MethodCallExpression)call.getObjectExpression() : null));
        return values;
    }

    private void addValue(Map<String, String> values, MethodCallExpression call) {
        String argumentValue = this.getArgumentValue(call);
        values.put(call.getMethodAsString(), argumentValue);
    }

    private String getArgumentValue(MethodCallExpression call) {
        ArgumentListExpression arguments = (ArgumentListExpression)call.getArguments();
        if (arguments.getExpressions().size() == 1) {
            return this.evaluateExpression(arguments.getExpression(0));
        }
        throw new RuntimeException(String.format("Method has %d arguments but only 1 argument is supported", arguments.getExpressions().size()));
    }
}

