/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.plugins.gradle.internal.utils;

import java.util.Objects;

public class ArtifactUtils {
    private static final String ARTIFACT_DELIMITER = ":";

    public String createName(String groupId, String artifactId) {
        return groupId + ARTIFACT_DELIMITER + artifactId;
    }

    public String createArtifact(String groupId, String artifactId, String version) {
        return this.createName(groupId, artifactId) + ARTIFACT_DELIMITER + version;
    }

    public String createArtifact(String groupId, String artifactId, String version, String packaging) {
        Object artifact = this.createArtifact(groupId, artifactId, version);
        if (Objects.nonNull(packaging)) {
            artifact = (String)artifact + ARTIFACT_DELIMITER + packaging;
        }
        return artifact;
    }

    public String createArtifactFromNameAndVersion(String name, String version) {
        return name + ARTIFACT_DELIMITER + version;
    }

    public ArtifactParts getArtifactParts(String artifact) {
        Objects.requireNonNull(artifact, "artifact");
        String[] parts = artifact.split(ARTIFACT_DELIMITER);
        if (parts.length < 3) {
            throw new IllegalArgumentException("artifact must contain at least 3 parts");
        }
        String packaging = parts.length > 3 ? parts[3] : null;
        return new ArtifactParts(parts[0], parts[1], this.createName(parts[0], parts[1]), parts[2], packaging);
    }

    public static final class ArtifactParts {
        private final String groupId;
        private final String artifactId;
        private final String name;
        private final String version;
        private final String packaging;

        public ArtifactParts(String groupId, String artifactId, String name, String version, String packaging) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.name = name;
            this.version = version;
            this.packaging = packaging;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getPackaging() {
            return this.packaging;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArtifactParts)) {
                return false;
            }
            ArtifactParts other = (ArtifactParts)o;
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$packaging = this.getPackaging();
            String other$packaging = other.getPackaging();
            return !(this$packaging == null ? other$packaging != null : !this$packaging.equals(other$packaging));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $packaging = this.getPackaging();
            result = result * 59 + ($packaging == null ? 43 : $packaging.hashCode());
            return result;
        }

        public String toString() {
            return "ArtifactUtils.ArtifactParts(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", packaging=" + this.getPackaging() + ")";
        }
    }
}

