/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.plugins.gradle.internal.services;

import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.kronicle.common.StringEscapeUtils;
import tech.kronicle.plugins.gradle.internal.services.PropertyRetriever;
import tech.kronicle.pluginutils.StringUtils;

public class PropertyExpander {
    private static final Logger log = LoggerFactory.getLogger(PropertyExpander.class);
    private final PropertyRetriever propertyRetriever;

    public String expandProperties(String value, String name, Map<String, String> properties, boolean bracesRequired) {
        StringUtils.requireNonEmpty((String)value, (String)"value");
        StringUtils.requireNonEmpty((String)name, (String)"name");
        Objects.requireNonNull(properties, "properties");
        int startIndex = value.indexOf("$");
        if (startIndex == -1) {
            return value;
        }
        StringBuilder newValue = new StringBuilder();
        int length = value.length();
        int endIndex = 0;
        do {
            newValue.append(value, endIndex, startIndex);
            if (startIndex + 1 == length) {
                throw new IllegalArgumentException(name + " with value \"" + StringEscapeUtils.escapeString((String)value) + "\" contains an empty \"$\" property reference");
            }
            boolean hasBrace = value.charAt(startIndex + 1) == '{';
            boolean handled = false;
            if (hasBrace || !bracesRequired) {
                if (hasBrace) {
                    endIndex = value.indexOf("}", startIndex + 2);
                    if (endIndex == -1) {
                        throw new IllegalArgumentException(name + " with value \"" + StringEscapeUtils.escapeString((String)value) + "\" contains an \"${\" property reference without a corresponding \"}\"");
                    }
                    ++endIndex;
                } else {
                    endIndex = startIndex + 1;
                    if (!this.isPropertyNameCharacter(value.charAt(endIndex))) {
                        throw new IllegalArgumentException(name + " with value \"" + StringEscapeUtils.escapeString((String)value) + "\" contains an \"$\" this is not followed by an alphanumeric character");
                    }
                    while (++endIndex < length && this.isPropertyNameCharacter(value.charAt(endIndex))) {
                    }
                }
                String propertyName = value.substring(this.getPropertyNameStartIndex(startIndex, hasBrace), this.getPropertyNameEndIndex(endIndex, hasBrace));
                if (log.isDebugEnabled()) {
                    log.debug("Property name '{}'", (Object)StringEscapeUtils.escapeString((String)propertyName));
                }
                String propertyValue = this.propertyRetriever.getPropertyValue(propertyName, properties);
                if (log.isDebugEnabled()) {
                    log.debug("Property value '{}'", (Object)StringEscapeUtils.escapeString((String)propertyValue));
                }
                if (Objects.nonNull(propertyValue)) {
                    if (propertyValue.contains("$")) {
                        if (log.isDebugEnabled()) {
                            log.debug("Expanding properties in property value '{}'", (Object)StringEscapeUtils.escapeString((String)propertyValue));
                        }
                        propertyValue = this.expandProperties(propertyValue, name, properties, bracesRequired);
                    }
                    newValue.append(propertyValue);
                    handled = true;
                }
            } else {
                endIndex = startIndex + 1;
            }
            if (handled) continue;
            newValue.append(value, startIndex, endIndex);
        } while ((startIndex = value.indexOf("$", endIndex)) != -1);
        newValue.append(value, endIndex, length);
        return newValue.toString();
    }

    private int getPropertyNameStartIndex(int startIndex, boolean hasBrace) {
        return startIndex + (hasBrace ? 2 : 1);
    }

    private int getPropertyNameEndIndex(int endIndex, boolean hasBrace) {
        return endIndex + (hasBrace ? -1 : 0);
    }

    private boolean isPropertyNameCharacter(char character) {
        return character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z' || character >= '0' && character <= '9' || character == '_' || character == '.';
    }

    public PropertyExpander(PropertyRetriever propertyRetriever) {
        this.propertyRetriever = propertyRetriever;
    }
}

