/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.plugins.gradle.internal.services;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import tech.kronicle.plugins.gradle.internal.models.Pom;
import tech.kronicle.plugins.gradle.internal.models.PomOutcome;
import tech.kronicle.plugins.gradle.internal.services.PomFetcher;
import tech.kronicle.plugins.gradle.internal.utils.ArtifactUtils;
import tech.kronicle.sdk.models.Software;
import tech.kronicle.sdk.models.SoftwareDependencyType;
import tech.kronicle.sdk.models.SoftwareRepository;
import tech.kronicle.sdk.models.SoftwareType;

public class DependencyVersionFetcher {
    private final PomFetcher pomFetcher;
    private final ArtifactUtils artifactUtils;

    public void findDependencyVersions(String pomArtifactCoordinates, Set<SoftwareRepository> softwareRepositories, Map<String, Set<String>> dependencyVersions, Set<Software> software) {
        this.addProjectObjectModelSoftware(pomArtifactCoordinates, SoftwareDependencyType.DIRECT, software);
        PomOutcome pomOutcome = this.pomFetcher.fetchPom(pomArtifactCoordinates, softwareRepositories);
        if (!pomOutcome.isJarOnly()) {
            Pom pom = pomOutcome.getPom();
            pom.getTransitiveArtifactCoordinates().forEach(artifact -> this.addProjectObjectModelSoftware((String)artifact, SoftwareDependencyType.TRANSITIVE, software));
            if (Objects.nonNull(pom.getDependencyManagementDependencies())) {
                pom.getDependencyManagementDependencies().forEach(item -> {
                    HashSet<String> versions = (HashSet<String>)dependencyVersions.get(item.getName());
                    if (Objects.isNull(versions)) {
                        versions = new HashSet<String>();
                        dependencyVersions.put(item.getName(), versions);
                    }
                    versions.add(item.getVersion());
                });
            }
        }
    }

    private void addProjectObjectModelSoftware(String pomArtifactCoordinates, SoftwareDependencyType dependencyType, Set<Software> software) {
        ArtifactUtils.ArtifactParts parts = this.artifactUtils.getArtifactParts(pomArtifactCoordinates);
        software.add(new Software(null, SoftwareType.JVM, dependencyType, parts.getName(), parts.getVersion(), null, "bom", null));
    }

    public DependencyVersionFetcher(PomFetcher pomFetcher, ArtifactUtils artifactUtils) {
        this.pomFetcher = pomFetcher;
        this.artifactUtils = artifactUtils;
    }
}

