/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.plugins.gradle.internal.services;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import tech.kronicle.plugins.gradle.config.GradleConfig;
import tech.kronicle.plugins.gradle.config.GradleCustomRepository;

public class CustomRepositoryRegistry {
    private final Map<String, String> customRepositoryUrls;

    public CustomRepositoryRegistry(GradleConfig config) {
        this.customRepositoryUrls = Optional.ofNullable(config.getCustomRepositories()).map(items -> items.stream().collect(Collectors.toMap(GradleCustomRepository::getName, GradleCustomRepository::getUrl))).orElse(Map.of());
    }

    public String getCustomRepositoryUrl(String name) {
        return this.customRepositoryUrls.get(name);
    }
}

