/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.plugins.gradle.internal.services;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.builder.AstBuilder;
import org.codehaus.groovy.control.CompilePhase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.kronicle.common.StringEscapeUtils;
import tech.kronicle.plugins.gradle.internal.services.BuildFileCache;
import tech.kronicle.plugins.gradle.internal.services.PropertyExpander;
import tech.kronicle.pluginutils.FileUtils;

public class BuildFileLoader {
    private static final Logger log = LoggerFactory.getLogger(BuildFileLoader.class);
    private final AstBuilder astBuilder = new AstBuilder();
    private final FileUtils fileUtils;
    private final BuildFileCache buildFileCache;
    private final PropertyExpander propertyExpander;

    public List<ASTNode> loadBuildFile(Path buildFile, Path codebaseDir) {
        if (!buildFile.startsWith(codebaseDir)) {
            throw new IllegalArgumentException(String.format("buildFile path \"%s\" is not within codebaseDir path \"%s\"", StringEscapeUtils.escapeString((String)buildFile.toString()), StringEscapeUtils.escapeString((String)codebaseDir.toString())));
        }
        String contents = this.fileUtils.readFileContent(buildFile);
        if (contents.isEmpty()) {
            return List.of();
        }
        List nodes = this.buildFileCache.getBuildFileNodes(contents);
        if (Objects.nonNull(nodes)) {
            log.debug("Used cached nodes for build file \"{}\"", (Object)buildFile);
        } else {
            log.debug("Built new nodes for build file \"{}\"", (Object)buildFile);
            nodes = this.astBuilder.buildFromString(CompilePhase.CONVERSION, false, contents);
            this.buildFileCache.putBuildFileNodes(contents, nodes);
        }
        return nodes;
    }

    public Path resolveApplyFromFile(String applyFromFileName, Path buildFile, Map<String, String> properties) {
        applyFromFileName = this.propertyExpander.expandProperties(applyFromFileName, "applyFromFileName", properties, false);
        return buildFile.getParent().resolve(Path.of(applyFromFileName, new String[0]));
    }

    public BuildFileLoader(FileUtils fileUtils, BuildFileCache buildFileCache, PropertyExpander propertyExpander) {
        this.fileUtils = fileUtils;
        this.buildFileCache = buildFileCache;
        this.propertyExpander = propertyExpander;
    }
}

