/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.plugins.gradle.internal.services;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.VisitorState;
import tech.kronicle.sdk.models.SoftwareDependencyType;
import tech.kronicle.sdk.models.SoftwareType;

public class BillOfMaterialsLogger {
    private static final Logger log = LoggerFactory.getLogger(BillOfMaterialsLogger.class);

    public void logManagedDependencies(VisitorState visitorState, Runnable action) {
        int directDependencyCount = this.getDirectDependencyCount(visitorState);
        int transitiveDependencyCount = this.getTransitiveDependencyCount(visitorState);
        int dependencyVersionCount = visitorState.getDependencyVersions().size();
        action.run();
        log.debug("Found {} direct bill of materials", (Object)(this.getDirectDependencyCount(visitorState) - directDependencyCount));
        log.debug("Found {} transitive bill of materials", (Object)(this.getTransitiveDependencyCount(visitorState) - transitiveDependencyCount));
        log.debug("Found {} dependency versions", (Object)(visitorState.getDependencyVersions().size() - dependencyVersionCount));
    }

    private int getDirectDependencyCount(VisitorState visitorState) {
        return this.getDependencyCount(visitorState, SoftwareDependencyType.DIRECT);
    }

    private int getTransitiveDependencyCount(VisitorState visitorState) {
        return this.getDependencyCount(visitorState, SoftwareDependencyType.TRANSITIVE);
    }

    private int getDependencyCount(VisitorState visitorState, SoftwareDependencyType dependencyType) {
        return (int)visitorState.getSoftware().stream().filter(software -> Objects.equals(software.getType(), SoftwareType.JVM) && Objects.equals(software.getPackaging(), "bom") && Objects.equals(software.getDependencyType(), dependencyType)).count();
    }
}

