/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.plugins.gradle.internal.services;

import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.CachingVersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.DefaultVersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.DefaultVersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import tech.kronicle.common.StringEscapeUtils;
import tech.kronicle.plugins.gradle.internal.services.ArtifactVersionsFetcher;
import tech.kronicle.plugins.gradle.internal.utils.ArtifactUtils;
import tech.kronicle.sdk.models.SoftwareRepository;

public class ArtifactVersionResolver {
    private final ArtifactVersionsFetcher artifactVersionsFetcher;
    private final ArtifactUtils artifactUtils;
    private final CachingVersionSelectorScheme versionSelectorScheme;
    private final VersionParser versionParser;
    private final Comparator<Version> versionComparator;

    public ArtifactVersionResolver(ArtifactVersionsFetcher artifactVersionsFetcher, ArtifactUtils artifactUtils) {
        this.artifactVersionsFetcher = artifactVersionsFetcher;
        this.artifactUtils = artifactUtils;
        this.versionSelectorScheme = new CachingVersionSelectorScheme((VersionSelectorScheme)new DefaultVersionSelectorScheme((VersionComparator)new DefaultVersionComparator(), new VersionParser()));
        this.versionParser = new VersionParser();
        this.versionComparator = new DefaultVersionComparator().asVersionComparator().reversed();
    }

    public String resolveArtifactVersion(String groupId, String artifactId, String version, Set<SoftwareRepository> softwareRepositories) {
        VersionSelector versionSelector = this.versionSelectorScheme.parseSelector(version);
        if (!versionSelector.isDynamic()) {
            return version;
        }
        Optional<Version> highestMatchingVersion = this.artifactVersionsFetcher.fetchArtifactVersions(groupId, artifactId, softwareRepositories).stream().map(arg_0 -> ((VersionParser)this.versionParser).transform(arg_0)).sorted(this.versionComparator).filter(arg_0 -> ((VersionSelector)versionSelector).accept(arg_0)).findFirst();
        if (highestMatchingVersion.isEmpty()) {
            throw new RuntimeException(String.format("Could not find matching version for \"%s\"", StringEscapeUtils.escapeString((String)this.artifactUtils.createArtifact(groupId, artifactId, version))));
        }
        return highestMatchingVersion.get().getSource();
    }
}

