/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.buildgradlevisitor;

import java.util.Objects;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.BaseVisitor;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.ExpressionVisitOutcome;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.buildgradlevisitor.BaseArtifactVisitorDependencies;
import tech.kronicle.plugins.gradle.internal.services.BillOfMaterialsLogger;
import tech.kronicle.plugins.gradle.internal.services.DependencyVersionFetcher;
import tech.kronicle.plugins.gradle.internal.utils.ArtifactUtils;
import tech.kronicle.pluginutils.ObjectReference;

public abstract class BaseArtifactVisitor
extends BaseVisitor {
    private final ArtifactUtils artifactUtils;
    private final DependencyVersionFetcher dependencyVersionFetcher;
    private final BillOfMaterialsLogger billOfMaterialsLogger;

    public BaseArtifactVisitor(BaseArtifactVisitorDependencies dependencies) {
        super(dependencies.getBaseDependencies());
        this.artifactUtils = dependencies.getArtifactUtils();
        this.dependencyVersionFetcher = dependencies.getDependencyVersionFetcher();
        this.billOfMaterialsLogger = dependencies.getBillOfMaterialsLogger();
    }

    protected ArtifactUtils artifactUtils() {
        return this.artifactUtils;
    }

    @Override
    protected final ExpressionVisitOutcome processMethodCallExpression(MethodCallExpression call) {
        if (this.shouldProcessArguments(call)) {
            this.processArguments(call);
            return ExpressionVisitOutcome.PROCESSED;
        }
        return ExpressionVisitOutcome.IGNORED;
    }

    protected boolean shouldProcessArguments(MethodCallExpression call) {
        return Objects.equals(call.getObjectExpression().getText(), "this");
    }

    protected final void processArguments(MethodCallExpression call) {
        if (call.getArguments() instanceof ArgumentListExpression) {
            ((ArgumentListExpression)call.getArguments()).getExpressions().forEach(argument -> {
                if (argument instanceof ConstantExpression) {
                    this.processArtifact((ConstantExpression)argument);
                } else if (argument instanceof GStringExpression) {
                    this.processArtifact((GStringExpression)argument);
                } else if (argument instanceof MapExpression) {
                    this.processArtifact((MapExpression)argument);
                } else if (argument instanceof BinaryExpression) {
                    this.processArtifact((BinaryExpression)argument);
                } else if (argument instanceof ListExpression) {
                    this.processArtifact((ListExpression)argument);
                } else if (argument instanceof MethodCallExpression) {
                    MethodCallExpression methodCallExpression = (MethodCallExpression)argument;
                    String methodName = methodCallExpression.getMethodAsString();
                    if (methodName.equals("platform")) {
                        this.processPlatform(methodCallExpression);
                    } else if (!(methodName.equals("project") || methodName.equals("localGroovy") || methodName.equals("gradleApi") || methodName.equals("files") || methodName.equals("fileTree"))) {
                        throw new RuntimeException("Unsupported method name " + methodName);
                    }
                } else if (!(argument instanceof ClosureExpression) && !(argument instanceof PropertyExpression)) {
                    throw new RuntimeException("Unsupported argument type " + argument.getClass().getName());
                }
            });
        } else if (call.getArguments() instanceof TupleExpression) {
            this.processArtifact((MapExpression)((TupleExpression)call.getArguments()).getExpression(0));
        } else {
            throw new RuntimeException("Unsupported arguments type " + call.getArguments().getClass().getName());
        }
    }

    protected void processPlatform(MethodCallExpression call) {
    }

    protected abstract void addArtifact(String var1, String var2, String var3, String var4);

    protected void addBillOfMaterialsArtifact(String groupId, String artifactId, String version, String packaging) {
        this.billOfMaterialsLogger.logManagedDependencies(this.visitorState(), () -> {
            String artifact = this.artifactUtils().createArtifact(groupId, artifactId, version, packaging);
            this.dependencyVersionFetcher.findDependencyVersions(artifact, this.getSoftwareRepositories(), this.visitorState().getDependencyVersions(), this.visitorState().getSoftware());
        });
    }

    private void processArtifact(ConstantExpression constant) {
        this.processArtifact(this.evaluateExpression((Expression)constant));
    }

    private void processArtifact(GStringExpression gstring) {
        this.processArtifact(this.evaluateExpression((Expression)gstring));
    }

    private void processArtifact(BinaryExpression binary) {
        this.processArtifact(this.evaluateExpression((Expression)binary));
    }

    private void processArtifact(ListExpression list) {
        list.getExpressions().forEach(expression -> this.processArtifact(this.evaluateExpression((Expression)expression)));
    }

    private void processArtifact(MapExpression map) {
        ObjectReference groupId = new ObjectReference();
        ObjectReference artifactId = new ObjectReference();
        ObjectReference version = new ObjectReference();
        try {
            map.getMapEntryExpressions().forEach(entry -> {
                String key = this.evaluateExpression(entry.getKeyExpression());
                String value = this.evaluateExpression(entry.getValueExpression());
                switch (key) {
                    case "group": {
                        groupId.set((Object)value);
                        break;
                    }
                    case "name": {
                        artifactId.set((Object)value);
                        break;
                    }
                    case "version": {
                        version.set((Object)value);
                        break;
                    }
                    case "classifier": 
                    case "ext": {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected artifact key \"" + key + "\"");
                    }
                }
            });
            this.processArtifact((String)groupId.get(), (String)artifactId.get(), (String)version.get(), null);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create software item for artifact", e);
        }
    }

    private void processArtifact(String artifact) {
        String[] artifactParts = artifact.split(":");
        if (artifactParts.length < 2 || artifactParts.length > 4) {
            throw new RuntimeException("Unexpected format of artifact");
        }
        String groupId = artifactParts[0];
        String artifactId = artifactParts[1];
        String version = artifactParts.length >= 3 ? artifactParts[2] : null;
        String packaging = artifactParts.length >= 4 ? artifactParts[3] : null;
        this.processArtifact(groupId, artifactId, version, packaging);
    }

    private void processArtifact(String groupId, String artifactId, String version, String packaging) {
        try {
            this.addArtifact(groupId, artifactId, version, packaging);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create software item for artifact", e);
        }
    }
}

