/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.plugins.gradle.internal.groovyscriptvisitors;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.BaseBuildFileVisitor;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.BaseBuildFileVisitorDependencies;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.ExpressionVisitOutcome;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.ProcessPhase;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.ProjectMode;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.buildgradlevisitor.BuildscriptVisitor;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.buildgradlevisitor.DependenciesVisitor;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.buildgradlevisitor.DependencyManagementVisitor;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.buildgradlevisitor.ExtOuterVisitor;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.buildgradlevisitor.MicronautVisitor;
import tech.kronicle.plugins.gradle.internal.services.PluginProcessor;
import tech.kronicle.sdk.models.Software;

public class BuildGradleVisitor
extends BaseBuildFileVisitor {
    private static final Logger log = LoggerFactory.getLogger(BuildGradleVisitor.class);
    private final BuildscriptVisitor buildscriptVisitor;
    private final DependencyManagementVisitor dependencyManagementVisitor;
    private final DependenciesVisitor dependenciesVisitor;
    private final ExtOuterVisitor extOuterVisitor;
    private final MicronautVisitor micronautVisitor;
    private final PluginProcessor pluginProcessor;

    public BuildGradleVisitor(BaseBuildFileVisitorDependencies dependencies, BuildscriptVisitor buildscriptVisitor, DependencyManagementVisitor dependencyManagementVisitor, DependenciesVisitor dependenciesVisitor, ExtOuterVisitor extOuterVisitor, MicronautVisitor micronautVisitor, PluginProcessor pluginProcessor) {
        super(dependencies);
        this.buildscriptVisitor = buildscriptVisitor;
        this.dependencyManagementVisitor = dependencyManagementVisitor;
        this.dependenciesVisitor = dependenciesVisitor;
        this.extOuterVisitor = extOuterVisitor;
        this.micronautVisitor = micronautVisitor;
        this.pluginProcessor = pluginProcessor;
    }

    @Override
    protected Logger log() {
        return log;
    }

    @Override
    protected ExpressionVisitOutcome processMethodCallExpression(MethodCallExpression call) {
        if (call.getMethodAsString().equals("allprojects")) {
            log.debug("Found allprojects");
            return ExpressionVisitOutcome.CONTINUE;
        }
        if (call.getMethodAsString().equals("subprojects")) {
            log.debug("Found subprojects");
            return this.visitorState().getProjectMode() == ProjectMode.SUBPROJECT ? ExpressionVisitOutcome.CONTINUE : ExpressionVisitOutcome.IGNORED;
        }
        if (call.getMethodAsString().equals("buildscript")) {
            if (this.visitorState().getProcessPhase() == ProcessPhase.PROPERTIES || this.visitorState().getProcessPhase() == ProcessPhase.BUILDSCRIPT_REPOSITORIES || this.visitorState().getProcessPhase() == ProcessPhase.BUILDSCRIPT_DEPENDENCIES) {
                log.debug("Found buildscript");
                this.visit(call.getArguments(), this.buildscriptVisitor);
                return ExpressionVisitOutcome.PROCESSED;
            }
            return ExpressionVisitOutcome.IGNORED_NO_WARNING;
        }
        if (call.getMethodAsString().equals("ext")) {
            if (this.visitorState().getProcessPhase() == ProcessPhase.PROPERTIES) {
                log.debug("Found ext");
                int count = this.visitorState().getProperties().size();
                this.visit((Expression)call, this.extOuterVisitor);
                log.debug("Found {} project properties", (Object)(this.visitorState().getProperties().size() - count));
                return ExpressionVisitOutcome.PROCESSED;
            }
            return ExpressionVisitOutcome.IGNORED_NO_WARNING;
        }
        if (call.getMethodAsString().equals("dependencies")) {
            if (this.visitorState().getProcessPhase() == ProcessPhase.DEPENDENCIES) {
                log.debug("Found dependencies");
                int count = this.visitorState().getSoftware().size();
                this.visit(call.getArguments(), this.dependenciesVisitor);
                log.debug("Found {} dependencies", (Object)(this.visitorState().getSoftware().size() - count));
                return ExpressionVisitOutcome.PROCESSED;
            }
            return ExpressionVisitOutcome.IGNORED_NO_WARNING;
        }
        if (call.getMethodAsString().equals("dependencyManagement")) {
            if (this.visitorState().getProcessPhase() == ProcessPhase.DEPENDENCY_MANAGEMENT) {
                log.debug("Found dependencyManagement");
                this.visit(call.getArguments(), this.dependencyManagementVisitor);
                return ExpressionVisitOutcome.PROCESSED;
            }
            return ExpressionVisitOutcome.IGNORED_NO_WARNING;
        }
        if (call.getMethodAsString().equals("micronaut")) {
            if (this.visitorState().getProcessPhase() == ProcessPhase.DEPENDENCY_MANAGEMENT) {
                log.debug("Found micronaut");
                this.visit(call.getArguments(), this.micronautVisitor);
                return ExpressionVisitOutcome.PROCESSED;
            }
            return ExpressionVisitOutcome.IGNORED_NO_WARNING;
        }
        return super.processMethodCallExpression(call);
    }

    @Override
    protected void processApplyPlugin(Map<String, String> values) {
        log.debug("Process apply plugin");
        int count = this.getPluginCount();
        String name = values.get("plugin");
        this.pluginProcessor.processPlugin(name, this.getPluginVersion(name), true, this.visitorState().getSoftware());
        log.debug("Found {} plugins", (Object)(this.getPluginCount() - count));
    }

    private String getPluginVersion(String name) {
        if (Objects.equals(name, "org.springframework.boot")) {
            Optional<Software> springBootPlugin = this.pluginProcessor.getPlugin("org.springframework.boot", this.visitorState().getSoftware());
            if (springBootPlugin.isPresent()) {
                return springBootPlugin.get().getVersion();
            }
            Optional<Software> springBootPluginDependency = this.pluginProcessor.getSpringBootPluginDependency(this.visitorState().getSoftware());
            if (springBootPluginDependency.isPresent()) {
                return springBootPluginDependency.get().getVersion();
            }
        }
        return null;
    }
}

