/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.plugins.gradle.internal.groovyscriptvisitors;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.LambdaExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.MethodReferenceExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.slf4j.Logger;
import tech.kronicle.common.StringEscapeUtils;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.ExpressionVisitOutcome;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.ProcessPhase;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.VisitorState;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.buildgradlevisitor.BaseVisitorDependencies;
import tech.kronicle.plugins.gradle.internal.services.BuildFileLoader;
import tech.kronicle.plugins.gradle.internal.services.BuildFileProcessor;
import tech.kronicle.plugins.gradle.internal.services.ExpressionEvaluator;
import tech.kronicle.plugins.gradle.internal.services.SoftwareRepositoryFactory;
import tech.kronicle.plugins.gradle.internal.utils.InheritingHashMap;
import tech.kronicle.plugins.gradle.internal.utils.InheritingHashSet;
import tech.kronicle.sdk.models.SoftwareRepository;
import tech.kronicle.sdk.models.SoftwareRepositoryScope;

public abstract class BaseVisitor
extends CodeVisitorSupport {
    private final BuildFileLoader buildFileLoader;
    private final BuildFileProcessor buildFileProcessor;
    private final ExpressionEvaluator expressionEvaluator;
    private final SoftwareRepositoryFactory softwareRepositoryFactory;
    private VisitorState visitorState;
    private InheritingHashMap<String, String> variables;

    public BaseVisitor(BaseVisitorDependencies dependencies) {
        this.buildFileLoader = dependencies.getBuildFileLoader();
        this.buildFileProcessor = dependencies.getBuildFileProcessor();
        this.expressionEvaluator = dependencies.getExpressionEvaluator();
        this.softwareRepositoryFactory = dependencies.getSoftwareRepositoryFactory();
    }

    protected abstract Logger log();

    protected final ExpressionEvaluator expressionEvaluator() {
        return this.expressionEvaluator;
    }

    protected final SoftwareRepositoryFactory softwareRepositoryFactory() {
        return this.softwareRepositoryFactory;
    }

    protected final VisitorState visitorState() {
        return this.visitorState;
    }

    public final void setVisitorState(VisitorState visitorState, InheritingHashMap<String, String> variables) {
        this.visitorState = visitorState;
        this.variables = new InheritingHashMap<String, String>((Map<String, String>)variables);
    }

    protected String evaluateExpression(Expression expression) {
        return this.expressionEvaluator.evaluateExpression(expression, this.variables, this.visitorState().getImports());
    }

    protected final void visit(Expression expression, BaseVisitor visitor) {
        visitor.setVisitorState(this.visitorState, this.variables);
        expression.visit((GroovyCodeVisitor)visitor);
    }

    public final void visitMethodCallExpression(MethodCallExpression call) {
        this.handleOutcome(call, this::processApply, ignored -> this.handleOutcome(call, this::processMethodCallExpression, x$0 -> super.visitMethodCallExpression(x$0), call.getMethodAsString()), call.getMethodAsString());
    }

    protected ExpressionVisitOutcome processMethodCallExpression(MethodCallExpression call) {
        return ExpressionVisitOutcome.CONTINUE;
    }

    public final void visitBinaryExpression(BinaryExpression expression) {
        this.handleOutcome(expression, this::processBinaryExpression, x$0 -> super.visitBinaryExpression(x$0), null);
    }

    protected ExpressionVisitOutcome processBinaryExpression(BinaryExpression expression) {
        if (expression instanceof DeclarationExpression) {
            this.log().debug("Found declaration");
            this.processDeclarationExpression((DeclarationExpression)expression);
            return ExpressionVisitOutcome.PROCESSED;
        }
        return ExpressionVisitOutcome.CONTINUE;
    }

    protected void processDeclarationExpression(DeclarationExpression expression) {
        this.variables.put(expression.getLeftExpression().getText(), this.evaluateExpression(expression.getRightExpression()));
    }

    protected ExpressionVisitOutcome processAssignment(BinaryExpression expression) {
        if (expression.getLeftExpression() instanceof PropertyExpression) {
            this.visitorState().getProperties().put(((PropertyExpression)expression.getLeftExpression()).getProperty().getText(), this.evaluateExpression(expression.getRightExpression()));
            return ExpressionVisitOutcome.PROCESSED;
        }
        return ExpressionVisitOutcome.IGNORED;
    }

    private <T extends Expression> void handleOutcome(T expression, Function<T, ExpressionVisitOutcome> thisMethod, Consumer<T> superMethod, String name) {
        ExpressionVisitOutcome outcome = thisMethod.apply(expression);
        switch (outcome) {
            case PROCESSED: 
            case IGNORED_NO_WARNING: {
                return;
            }
            case IGNORED: {
                if (Objects.nonNull(name)) {
                    this.log().info("{} {} ignored", (Object)expression.getClass().getName(), (Object)name);
                } else {
                    this.log().info("{} ignored", (Object)expression.getClass().getName());
                }
                return;
            }
            case CONTINUE: {
                superMethod.accept(expression);
                return;
            }
        }
        throw new RuntimeException(String.format("Unexpected outcome %s", new Object[]{outcome}));
    }

    protected void addSoftwareRepository(String url) {
        this.getSoftwareRepositories().add(this.softwareRepositoryFactory.createSoftwareRepository(url, this.getSoftwareRepositoryScope()));
    }

    private SoftwareRepositoryScope getSoftwareRepositoryScope() {
        switch (this.visitorState.getProcessPhase()) {
            case BUILDSCRIPT_REPOSITORIES: {
                return SoftwareRepositoryScope.BUILDSCRIPT;
            }
            case REPOSITORIES: {
                return null;
            }
        }
        throw new RuntimeException("Unexpected process phase " + this.visitorState.getProcessPhase());
    }

    protected InheritingHashSet<SoftwareRepository> getSoftwareRepositories() {
        switch (this.visitorState.getProcessPhase()) {
            case BUILDSCRIPT_REPOSITORIES: 
            case PLUGINS: 
            case BUILDSCRIPT_DEPENDENCIES: 
            case APPLY_PLUGINS: {
                return this.visitorState.getBuildscriptSoftwareRepositories();
            }
            case REPOSITORIES: 
            case DEPENDENCY_MANAGEMENT: 
            case DEPENDENCIES: {
                return this.visitorState.getSoftwareRepositories();
            }
        }
        throw new RuntimeException("Unexpected process phase " + this.visitorState.getProcessPhase());
    }

    private ExpressionVisitOutcome processApply(MethodCallExpression call) {
        if (call.getMethodAsString().equals("apply")) {
            TupleExpression arguments;
            this.log().debug("Found apply");
            if (call.getArguments() instanceof TupleExpression && (arguments = (TupleExpression)call.getArguments()).getExpressions().size() == 1 && arguments.getExpression(0) instanceof NamedArgumentListExpression) {
                NamedArgumentListExpression namedArguments = (NamedArgumentListExpression)arguments.getExpression(0);
                Map<String, String> values = namedArguments.getMapEntryExpressions().stream().collect(Collectors.toMap(entry -> this.evaluateExpression(entry.getKeyExpression()), entry -> this.evaluateExpression(entry.getValueExpression())));
                if (values.size() == 1 && values.containsKey("plugin")) {
                    if (this.visitorState.getProcessPhase() == ProcessPhase.APPLY_PLUGINS) {
                        this.processApplyPlugin(values);
                        return ExpressionVisitOutcome.PROCESSED;
                    }
                    return ExpressionVisitOutcome.IGNORED_NO_WARNING;
                }
                if (values.size() == 1 && values.containsKey("from") || values.size() == 2 && values.containsKey("from") && values.containsKey("to")) {
                    String from = values.get("from");
                    Path applyFile = this.buildFileLoader.resolveApplyFromFile(from, this.visitorState.getBuildFile(), this.variables);
                    this.log().debug("Processing file \"{}\"", (Object)StringEscapeUtils.escapeString((String)this.visitorState.getCodebaseDir().relativize(applyFile).toString()));
                    List<ASTNode> nodes = this.buildFileLoader.loadBuildFile(applyFile, this.visitorState.getCodebaseDir());
                    VisitorState oldVisitorState = this.visitorState;
                    this.visitorState = this.visitorState.withApplyFile(applyFile);
                    this.buildFileProcessor.visitNodes(nodes, this);
                    this.visitorState = oldVisitorState;
                    this.log().debug("Finished processing file \"{}\"", (Object)StringEscapeUtils.escapeString((String)from));
                    return ExpressionVisitOutcome.PROCESSED;
                }
                throw new RuntimeException(String.format("apply call with unexpected arguments %s", String.join((CharSequence)", ", values.keySet())));
            }
        }
        return ExpressionVisitOutcome.CONTINUE;
    }

    protected void processApplyPlugin(Map<String, String> values) {
    }

    public final void visitBlockStatement(BlockStatement block) {
        super.visitBlockStatement(block);
    }

    public final void visitForLoop(ForStatement forLoop) {
        super.visitForLoop(forLoop);
    }

    public final void visitWhileLoop(WhileStatement loop) {
        super.visitWhileLoop(loop);
    }

    public final void visitDoWhileLoop(DoWhileStatement loop) {
        super.visitDoWhileLoop(loop);
    }

    public final void visitIfElse(IfStatement ifElse) {
        super.visitIfElse(ifElse);
    }

    public final void visitExpressionStatement(ExpressionStatement statement) {
        super.visitExpressionStatement(statement);
    }

    public final void visitReturnStatement(ReturnStatement statement) {
        super.visitReturnStatement(statement);
    }

    public final void visitAssertStatement(AssertStatement statement) {
        super.visitAssertStatement(statement);
    }

    public final void visitTryCatchFinally(TryCatchStatement statement) {
        super.visitTryCatchFinally(statement);
    }

    public final void visitEmptyStatement(EmptyStatement statement) {
        super.visitEmptyStatement(statement);
    }

    public final void visitSwitch(SwitchStatement statement) {
        super.visitSwitch(statement);
    }

    protected void afterSwitchConditionExpressionVisited(SwitchStatement statement) {
        super.afterSwitchConditionExpressionVisited(statement);
    }

    public final void visitCaseStatement(CaseStatement statement) {
        super.visitCaseStatement(statement);
    }

    public final void visitBreakStatement(BreakStatement statement) {
        super.visitBreakStatement(statement);
    }

    public final void visitContinueStatement(ContinueStatement statement) {
        super.visitContinueStatement(statement);
    }

    public final void visitSynchronizedStatement(SynchronizedStatement statement) {
        super.visitSynchronizedStatement(statement);
    }

    public final void visitThrowStatement(ThrowStatement statement) {
        super.visitThrowStatement(statement);
    }

    public final void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
        super.visitStaticMethodCallExpression(call);
    }

    public final void visitConstructorCallExpression(ConstructorCallExpression call) {
        super.visitConstructorCallExpression(call);
    }

    public final void visitTernaryExpression(TernaryExpression expression) {
        super.visitTernaryExpression(expression);
    }

    public final void visitShortTernaryExpression(ElvisOperatorExpression expression) {
        super.visitShortTernaryExpression(expression);
    }

    public final void visitPostfixExpression(PostfixExpression expression) {
        super.visitPostfixExpression(expression);
    }

    public final void visitPrefixExpression(PrefixExpression expression) {
        super.visitPrefixExpression(expression);
    }

    public final void visitBooleanExpression(BooleanExpression expression) {
        super.visitBooleanExpression(expression);
    }

    public final void visitNotExpression(NotExpression expression) {
        super.visitNotExpression(expression);
    }

    public final void visitClosureExpression(ClosureExpression expression) {
        super.visitClosureExpression(expression);
    }

    public final void visitLambdaExpression(LambdaExpression expression) {
        super.visitLambdaExpression(expression);
    }

    public final void visitTupleExpression(TupleExpression expression) {
        super.visitTupleExpression(expression);
    }

    public final void visitListExpression(ListExpression expression) {
        super.visitListExpression(expression);
    }

    public final void visitArrayExpression(ArrayExpression expression) {
        super.visitArrayExpression(expression);
    }

    public final void visitMapExpression(MapExpression expression) {
        super.visitMapExpression(expression);
    }

    public final void visitMapEntryExpression(MapEntryExpression expression) {
        super.visitMapEntryExpression(expression);
    }

    public final void visitRangeExpression(RangeExpression expression) {
        super.visitRangeExpression(expression);
    }

    public final void visitSpreadExpression(SpreadExpression expression) {
        super.visitSpreadExpression(expression);
    }

    public final void visitSpreadMapExpression(SpreadMapExpression expression) {
        super.visitSpreadMapExpression(expression);
    }

    public final void visitMethodPointerExpression(MethodPointerExpression expression) {
        super.visitMethodPointerExpression(expression);
    }

    public final void visitMethodReferenceExpression(MethodReferenceExpression expression) {
        super.visitMethodReferenceExpression(expression);
    }

    public final void visitUnaryMinusExpression(UnaryMinusExpression expression) {
        super.visitUnaryMinusExpression(expression);
    }

    public final void visitUnaryPlusExpression(UnaryPlusExpression expression) {
        super.visitUnaryPlusExpression(expression);
    }

    public final void visitBitwiseNegationExpression(BitwiseNegationExpression expression) {
        super.visitBitwiseNegationExpression(expression);
    }

    public final void visitCastExpression(CastExpression expression) {
        super.visitCastExpression(expression);
    }

    public final void visitConstantExpression(ConstantExpression expression) {
        super.visitConstantExpression(expression);
    }

    public final void visitClassExpression(ClassExpression expression) {
        super.visitClassExpression(expression);
    }

    public final void visitVariableExpression(VariableExpression expression) {
        super.visitVariableExpression(expression);
    }

    public final void visitDeclarationExpression(DeclarationExpression expression) {
        super.visitDeclarationExpression(expression);
    }

    public final void visitPropertyExpression(PropertyExpression expression) {
        super.visitPropertyExpression(expression);
    }

    public final void visitAttributeExpression(AttributeExpression expression) {
        super.visitAttributeExpression(expression);
    }

    public final void visitFieldExpression(FieldExpression expression) {
        super.visitFieldExpression(expression);
    }

    public final void visitGStringExpression(GStringExpression expression) {
        super.visitGStringExpression(expression);
    }

    public final void visitCatchStatement(CatchStatement statement) {
        super.visitCatchStatement(statement);
    }

    public final void visitArgumentlistExpression(ArgumentListExpression expression) {
        super.visitArgumentlistExpression(expression);
    }

    public final void visitClosureListExpression(ClosureListExpression expression) {
        super.visitClosureListExpression(expression);
    }

    public final void visitBytecodeExpression(BytecodeExpression expression) {
        super.visitBytecodeExpression(expression);
    }

    public final void visitEmptyExpression(EmptyExpression expression) {
        super.visitEmptyExpression(expression);
    }

    public final void visitListOfExpressions(List<? extends Expression> list) {
        super.visitListOfExpressions(list);
    }
}

