/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.plugins.gradle.internal.groovyscriptvisitors;

import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.BaseBuildFileVisitorDependencies;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.BaseVisitor;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.ExpressionVisitOutcome;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.ProcessPhase;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.buildgradlevisitor.PluginsVisitor;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.buildgradlevisitor.RepositoriesVisitor;
import tech.kronicle.plugins.gradle.internal.services.PluginProcessor;

public abstract class BaseBuildFileVisitor
extends BaseVisitor {
    private final PluginsVisitor pluginsVisitor;
    private final RepositoriesVisitor repositoriesVisitor;
    private final PluginProcessor pluginProcessor;

    public BaseBuildFileVisitor(BaseBuildFileVisitorDependencies dependencies) {
        super(dependencies.getBaseDependencies());
        this.pluginsVisitor = dependencies.getPluginsVisitor();
        this.repositoriesVisitor = dependencies.getRepositoriesVisitor();
        this.pluginProcessor = dependencies.getPluginProcessor();
    }

    @Override
    protected ExpressionVisitOutcome processMethodCallExpression(MethodCallExpression call) {
        if (call.getMethodAsString().equals("import")) {
            this.log().debug("Found import");
            return ExpressionVisitOutcome.PROCESSED;
        }
        if (call.getMethodAsString().equals("plugins")) {
            if (this.visitorState().getProcessPhase() == ProcessPhase.PLUGINS) {
                this.log().debug("Found plugins");
                int count = this.getPluginCount();
                this.visit(call.getArguments(), this.pluginsVisitor);
                this.log().debug("Found {} plugins", (Object)(this.getPluginCount() - count));
                return ExpressionVisitOutcome.PROCESSED;
            }
            return ExpressionVisitOutcome.IGNORED_NO_WARNING;
        }
        if (call.getMethodAsString().equals("repositories")) {
            if (this.visitorState().getProcessPhase() == this.getRepositoriesProcessPhase()) {
                this.log().debug("Found repositories");
                int count = this.getSoftwareRepositories().size();
                this.visit(call.getArguments(), this.repositoriesVisitor);
                this.log().debug("Found {} repositories", (Object)(this.getSoftwareRepositories().size() - count));
                return ExpressionVisitOutcome.PROCESSED;
            }
            return ExpressionVisitOutcome.IGNORED_NO_WARNING;
        }
        return super.processMethodCallExpression(call);
    }

    protected ProcessPhase getRepositoriesProcessPhase() {
        return ProcessPhase.REPOSITORIES;
    }

    @Override
    protected ExpressionVisitOutcome processBinaryExpression(BinaryExpression expression) {
        if (expression.getLeftExpression() instanceof PropertyExpression) {
            if (this.visitorState().getProcessPhase() == ProcessPhase.PROPERTIES) {
                this.log().debug("Found property");
                Expression object = ((PropertyExpression)expression.getLeftExpression()).getObjectExpression();
                if (object instanceof VariableExpression && ((VariableExpression)object).getName().equals("ext")) {
                    return this.processAssignment(expression);
                }
                return ExpressionVisitOutcome.IGNORED;
            }
            return ExpressionVisitOutcome.IGNORED_NO_WARNING;
        }
        return super.processBinaryExpression(expression);
    }

    protected int getPluginCount() {
        return this.pluginProcessor.getPluginCount(this.visitorState().getSoftware());
    }
}

