/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.plugins.gradle;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.codehaus.groovy.ast.ASTNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.kronicle.common.StringEscapeUtils;
import tech.kronicle.plugins.gradle.GradleAnalysis;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.BaseBuildFileVisitor;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.BuildGradleVisitor;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.ProcessPhase;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.ProjectMode;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.SettingsGradleVisitor;
import tech.kronicle.plugins.gradle.internal.groovyscriptvisitors.VisitorState;
import tech.kronicle.plugins.gradle.internal.models.Import;
import tech.kronicle.plugins.gradle.internal.services.BuildFileLoader;
import tech.kronicle.plugins.gradle.internal.services.BuildFileProcessor;
import tech.kronicle.plugins.gradle.internal.services.DependencyVersionFetcher;
import tech.kronicle.plugins.gradle.internal.services.PluginProcessor;
import tech.kronicle.plugins.gradle.internal.services.SoftwareRepositoryFactory;
import tech.kronicle.plugins.gradle.internal.utils.ArtifactUtils;
import tech.kronicle.plugins.gradle.internal.utils.InheritingHashMap;
import tech.kronicle.plugins.gradle.internal.utils.InheritingHashSet;
import tech.kronicle.pluginutils.Comparators;
import tech.kronicle.pluginutils.FileUtils;
import tech.kronicle.sdk.models.Software;
import tech.kronicle.sdk.models.SoftwareDependencyType;
import tech.kronicle.sdk.models.SoftwareRepository;
import tech.kronicle.sdk.models.SoftwareRepositoryScope;
import tech.kronicle.sdk.models.SoftwareType;

public class GradleStaticAnalyzer {
    private static final Logger log = LoggerFactory.getLogger(GradleStaticAnalyzer.class);
    private static final Pattern GRADLE_WRAPPER_VERSION_EXTRACTION_PATTERN = Pattern.compile("/gradle-([0-9]+\\.[0-9]+(\\.[0-9]+)?)-");
    private static final List<ProcessPhase> PROCESS_PHASES = List.of(ProcessPhase.INITIALIZE, ProcessPhase.PROPERTIES, ProcessPhase.PLUGINS, ProcessPhase.BUILDSCRIPT_REPOSITORIES, ProcessPhase.BUILDSCRIPT_DEPENDENCIES, ProcessPhase.APPLY_PLUGINS, ProcessPhase.REPOSITORIES, ProcessPhase.DEPENDENCY_MANAGEMENT, ProcessPhase.DEPENDENCIES, ProcessPhase.FINALIZE);
    private final SettingsGradleVisitor settingsGradleVisitor;
    private final BuildGradleVisitor buildGradleVisitor;
    private final BuildFileLoader buildFileLoader;
    private final DependencyVersionFetcher dependencyVersionFetcher;
    private final ArtifactUtils artifactUtils;
    private final PluginProcessor pluginProcessor;
    private final SoftwareRepositoryFactory softwareRepositoryFactory;
    private final BuildFileProcessor buildFileProcessor;
    private final FileUtils fileUtils;

    public GradleAnalysis analyzeCodebase(Path codebaseDir) {
        HashSet allSoftwareRepositories = new HashSet();
        HashSet<Software> allSoftware = new HashSet<Software>();
        Path gradleWrapperPropertiesFile = codebaseDir.resolve("gradle").resolve("wrapper").resolve("gradle-wrapper.properties");
        if (Files.exists(gradleWrapperPropertiesFile, new LinkOption[0])) {
            Properties gradleWrapperProperties = this.fileUtils.loadProperties(gradleWrapperPropertiesFile);
            String distributionUrl = Objects.requireNonNull(gradleWrapperProperties.getProperty("distributionUrl"), "distributionUrl in gradle-wrapper.properties file does not contain \"distributionUrl\" property");
            allSoftware.add(Software.builder().type(SoftwareType.TOOL).dependencyType(SoftwareDependencyType.DIRECT).name("gradle-wrapper").version(this.extractGradleWrapperVersionFromDistributionUrl(distributionUrl)).build());
        }
        HashMap<String, String> rootProperties = new HashMap<String, String>();
        rootProperties.put("rootDir", codebaseDir.toString());
        rootProperties.put("rootProject.projectDir", codebaseDir.toString());
        rootProperties.put("rootProject.name", codebaseDir.getFileName().toString());
        long buildFileCount = this.fileUtils.findFiles(codebaseDir, this::matchBuildFile).peek(buildFile -> {
            log.debug("Found build file \"" + StringEscapeUtils.escapeString((String)buildFile.toString()) + "\"");
            List<Path> buildFileChain = this.getBuildFileChain(codebaseDir, (Path)buildFile);
            ArrayList properties = new ArrayList();
            ArrayList buildscriptSoftwareRepositories = new ArrayList();
            ArrayList softwareRepositories = new ArrayList();
            ArrayList software = new ArrayList();
            ArrayList dependencyVersions = new ArrayList();
            PROCESS_PHASES.forEach(processPhase -> {
                log.debug("Beginning {} phase", (Object)processPhase);
                int count = buildFileChain.size();
                for (int index = 0; index < count; ++index) {
                    ProjectMode projectMode = this.getProjectMode(buildFileChain, index);
                    InheritingHashMap currentProperties = this.getInheritingItem(properties, index, (ProcessPhase)((Object)((Object)processPhase)), () -> this.cloneValues(rootProperties), InheritingHashMap::new);
                    InheritingHashSet currentBuildscriptSoftwareRepositories = this.getInheritingItem(buildscriptSoftwareRepositories, index, (ProcessPhase)((Object)((Object)processPhase)), InheritingHashSet::new, InheritingHashSet::new);
                    InheritingHashSet currentSoftwareRepositories = this.getInheritingItem(softwareRepositories, index, (ProcessPhase)((Object)((Object)processPhase)), InheritingHashSet::new, InheritingHashSet::new);
                    InheritingHashSet currentSoftware = this.getInheritingItem(software, index, (ProcessPhase)((Object)((Object)processPhase)), InheritingHashSet::new, InheritingHashSet::new);
                    InheritingHashMap currentDependencyVersions = this.getInheritingItem(dependencyVersions, index, (ProcessPhase)((Object)((Object)processPhase)), InheritingHashMap::new, InheritingHashMap::new);
                    Path currentBuildFile = (Path)buildFileChain.get(index);
                    log.debug("Processing build file \"" + StringEscapeUtils.escapeString((String)currentBuildFile.toString()) + "\"");
                    if (processPhase == ProcessPhase.INITIALIZE) {
                        Path gradlePropertiesFile;
                        if (projectMode != ProjectMode.SETTINGS) {
                            Path projectDir = currentBuildFile.getParent();
                            currentProperties.put("project.name", projectDir.getFileName().toString());
                            Object propertyName = "projectDir";
                            while (projectDir.startsWith(codebaseDir)) {
                                currentProperties.put(propertyName, projectDir.toString());
                                projectDir = projectDir.getParent();
                                propertyName = (String)propertyName + ".parent";
                            }
                        }
                        if (!Files.exists(gradlePropertiesFile = currentBuildFile.getParent().resolve("gradle.properties"), new LinkOption[0])) continue;
                        Properties gradleProperties = this.fileUtils.loadProperties(gradlePropertiesFile);
                        this.addPropertiesToPropertyMap(gradleProperties, currentProperties);
                        continue;
                    }
                    if (processPhase == ProcessPhase.FINALIZE) {
                        if (!this.isLastBuildFileInChain(buildFileChain, index)) continue;
                        allSoftwareRepositories.addAll(currentBuildscriptSoftwareRepositories);
                        allSoftwareRepositories.addAll(currentSoftwareRepositories);
                        allSoftware.addAll(currentSoftware);
                        continue;
                    }
                    if (processPhase == ProcessPhase.DEPENDENCIES && projectMode != ProjectMode.SETTINGS) {
                        this.emulateSpringBootPlugin(currentSoftwareRepositories, currentSoftware, currentDependencyVersions);
                        this.emulateMicronautApplicationPlugin(currentProperties, currentSoftwareRepositories, currentSoftware, currentDependencyVersions);
                        this.emulateMicronautLibraryPlugin(currentProperties, currentSoftwareRepositories, currentSoftware, currentDependencyVersions);
                    }
                    if (Files.exists(currentBuildFile, new LinkOption[0])) {
                        List<ASTNode> nodes = this.buildFileLoader.loadBuildFile(currentBuildFile, codebaseDir);
                        try {
                            Set<Import> imports = this.buildFileProcessor.getImports(nodes);
                            VisitorState visitorState = new VisitorState((ProcessPhase)((Object)((Object)processPhase)), projectMode, codebaseDir, currentBuildFile, null, imports, currentBuildscriptSoftwareRepositories, currentSoftwareRepositories, currentSoftware, currentProperties, currentDependencyVersions);
                            BaseBuildFileVisitor visitor = projectMode == ProjectMode.SETTINGS ? this.settingsGradleVisitor : this.buildGradleVisitor;
                            visitor.setVisitorState(visitorState, visitorState.getProperties());
                            this.buildFileProcessor.visitNodes(nodes, visitor);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(String.format("Failed to process build file \"%s\" for %s project mode and %s process phase", new Object[]{StringEscapeUtils.escapeString((String)currentBuildFile.toString()), projectMode, processPhase}), e);
                        }
                    }
                    if (processPhase != ProcessPhase.BUILDSCRIPT_REPOSITORIES || projectMode == ProjectMode.SETTINGS || this.pluginProcessor.getPluginCount(currentSoftware) <= 0 || !currentBuildscriptSoftwareRepositories.isEmpty()) continue;
                    currentBuildscriptSoftwareRepositories.add(this.softwareRepositoryFactory.createSoftwareRepository("https://plugins.gradle.org/m2/", SoftwareRepositoryScope.BUILDSCRIPT));
                }
            });
        }).count();
        boolean gradleIsUsed = buildFileCount > 0L;
        List<SoftwareRepository> allSoftwareRepositoriesList = allSoftwareRepositories.stream().sorted(Comparators.SOFTWARE_REPOSITORIES).collect(Collectors.toList());
        List<Software> allSoftwareList = allSoftware.stream().sorted(Comparators.SOFTWARE).collect(Collectors.toList());
        return new GradleAnalysis(gradleIsUsed, allSoftwareRepositoriesList, allSoftwareList);
    }

    private void emulateSpringBootPlugin(InheritingHashSet<SoftwareRepository> softwareRepositories, InheritingHashSet<Software> software, InheritingHashMap<String, Set<String>> dependencyVersions) {
        this.emulateBomPlugin("org.springframework.boot", "org.springframework.boot:spring-boot-dependencies", Software::getVersion, softwareRepositories, software, dependencyVersions);
    }

    private void emulateMicronautApplicationPlugin(InheritingHashMap<String, String> properties, InheritingHashSet<SoftwareRepository> softwareRepositories, InheritingHashSet<Software> software, InheritingHashMap<String, Set<String>> dependencyVersions) {
        this.emulateBomPlugin("io.micronaut.application", "io.micronaut:micronaut-bom", ignored -> this.getMicronautVersion(properties), softwareRepositories, software, dependencyVersions);
    }

    private void emulateMicronautLibraryPlugin(InheritingHashMap<String, String> properties, InheritingHashSet<SoftwareRepository> softwareRepositories, InheritingHashSet<Software> software, InheritingHashMap<String, Set<String>> dependencyVersions) {
        this.emulateBomPlugin("io.micronaut.library", "io.micronaut:micronaut-bom", ignored -> this.getMicronautVersion(properties), softwareRepositories, software, dependencyVersions);
    }

    private void emulateBomPlugin(String pluginName, String bomCoordinates, Function<Software, String> versionGetter, Set<SoftwareRepository> softwareRepositories, Set<Software> software, Map<String, Set<String>> dependencyVersions) {
        this.pluginProcessor.getPlugin(pluginName, software).ifPresent(plugin -> this.dependencyVersionFetcher.findDependencyVersions(this.artifactUtils.createArtifactFromNameAndVersion(bomCoordinates, (String)versionGetter.apply((Software)plugin)), softwareRepositories, dependencyVersions, software));
    }

    private String getMicronautVersion(InheritingHashMap<String, String> currentProperties) {
        String micronautVersion = currentProperties.get("micronautVersion");
        if (Objects.isNull(micronautVersion)) {
            throw new RuntimeException("Micronaut version not set. Use micronaut { version '..'} or 'micronautVersion' in gradle.properties to set the version");
        }
        return micronautVersion;
    }

    private ProjectMode getProjectMode(List<Path> buildFileChain, int index) {
        ProjectMode projectMode = index == 0 && this.isSettingsGradleFile(buildFileChain.get(index)) ? ProjectMode.SETTINGS : (this.isLastBuildFileInChain(buildFileChain, index) ? ProjectMode.THIS_PROJECT : ProjectMode.SUBPROJECT);
        return projectMode;
    }

    private boolean isSettingsGradleFile(Path file) {
        return Objects.equals(file.getFileName().toString(), "settings.gradle");
    }

    private <T> T getInheritingItem(List<T> list, int index, ProcessPhase processPhase, Supplier<T> initializeRoot, UnaryOperator<T> initializeChild) {
        if (processPhase == ProcessPhase.INITIALIZE) {
            T item = index == 0 ? initializeRoot.get() : initializeChild.apply(this.getParentItem(list, index));
            list.add(item);
            return item;
        }
        return list.get(index);
    }

    private <T> T getParentItem(List<T> list, int index) {
        return list.get(index - 1);
    }

    protected InheritingHashMap<String, String> cloneValues(HashMap<String, String> values) {
        InheritingHashMap<String, String> newValues = new InheritingHashMap<String, String>();
        newValues.putAll(values);
        return newValues;
    }

    private boolean isLastBuildFileInChain(List<Path> buildFileChain, int index) {
        return index == buildFileChain.size() - 1;
    }

    private List<Path> getBuildFileChain(Path codebaseDir, Path buildFile) {
        ArrayList<Path> buildFileChain = new ArrayList<Path>();
        Path currentBuildFile = buildFile;
        do {
            buildFileChain.add(0, currentBuildFile);
        } while ((currentBuildFile = currentBuildFile.getParent().getParent().resolve("build.gradle")).startsWith(codebaseDir));
        currentBuildFile = codebaseDir.resolve("settings.gradle");
        buildFileChain.add(0, currentBuildFile);
        return buildFileChain;
    }

    private void addPropertiesToPropertyMap(Properties gradleProperties, HashMap<String, String> properties) {
        gradleProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(name, value) -> properties.put((String)name, (String)value)));
    }

    private String extractGradleWrapperVersionFromDistributionUrl(String distributionUrl) {
        Matcher matcher = GRADLE_WRAPPER_VERSION_EXTRACTION_PATTERN.matcher(distributionUrl);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Could not extract Gradle Wrapper version from distribution URL \"" + StringEscapeUtils.escapeString((String)distributionUrl) + "\"");
        }
        return matcher.group(1);
    }

    private boolean matchBuildFile(Path path, BasicFileAttributes basicFileAttributes) {
        return basicFileAttributes.isRegularFile() && Objects.equals(path.getFileName().toString(), "build.gradle");
    }

    public GradleStaticAnalyzer(SettingsGradleVisitor settingsGradleVisitor, BuildGradleVisitor buildGradleVisitor, BuildFileLoader buildFileLoader, DependencyVersionFetcher dependencyVersionFetcher, ArtifactUtils artifactUtils, PluginProcessor pluginProcessor, SoftwareRepositoryFactory softwareRepositoryFactory, BuildFileProcessor buildFileProcessor, FileUtils fileUtils) {
        this.settingsGradleVisitor = settingsGradleVisitor;
        this.buildGradleVisitor = buildGradleVisitor;
        this.buildFileLoader = buildFileLoader;
        this.dependencyVersionFetcher = dependencyVersionFetcher;
        this.artifactUtils = artifactUtils;
        this.pluginProcessor = pluginProcessor;
        this.softwareRepositoryFactory = softwareRepositoryFactory;
        this.buildFileProcessor = buildFileProcessor;
        this.fileUtils = fileUtils;
    }
}

