/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.statistic.infrastructure.secondary;

import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.statistic.domain.AppliedModule;
import tech.jhipster.lite.statistic.domain.Statistics;
import tech.jhipster.lite.statistic.domain.StatisticsRepository;
import tech.jhipster.lite.statistic.domain.criteria.StatisticsCriteria;
import tech.jhipster.lite.statistic.infrastructure.secondary.AppliedModuleDocument;
import tech.jhipster.lite.statistic.infrastructure.secondary.SpringDataMongoDBStatisticsRepository;
import tech.jhipster.lite.statistic.infrastructure.secondary.WithMongoDB;

@WithMongoDB
@Repository
class MongoDBStatisticsRepository
implements StatisticsRepository {
    private final SpringDataMongoDBStatisticsRepository statistics;
    private final MongoTemplate mongoTemplate;

    MongoDBStatisticsRepository(SpringDataMongoDBStatisticsRepository statistics, MongoTemplate mongoTemplate) {
        this.statistics = statistics;
        this.mongoTemplate = mongoTemplate;
    }

    @Override
    public void save(AppliedModule moduleApplied) {
        Assert.notNull("moduleApplied", moduleApplied);
        this.statistics.save(AppliedModuleDocument.from(moduleApplied));
    }

    @Override
    public Statistics get(@NotNull StatisticsCriteria criteria) {
        if (criteria.isAnyCriteriaApplied()) {
            Query query = this.generateQuery(criteria);
            return new Statistics(this.mongoTemplate.count(query, AppliedModuleDocument.class));
        }
        return new Statistics(this.statistics.count());
    }

    private Query generateQuery(@NotNull StatisticsCriteria criteria) {
        ArrayList criteriaList = new ArrayList();
        criteria.getStartTime().ifPresent(startTime -> criteriaList.add(Criteria.where((String)"date").gte(startTime)));
        criteria.getEndTime().ifPresent(endTime -> criteriaList.add(Criteria.where((String)"date").lte(endTime)));
        criteria.getModuleSlug().ifPresent(moduleSlug -> criteriaList.add(Criteria.where((String)"moduleSlug").is((Object)moduleSlug.get())));
        return new Query((CriteriaDefinition)new Criteria().andOperator(criteriaList.toArray(new Criteria[0])));
    }
}

