/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.shared.error.domain;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import tech.jhipster.lite.shared.error.domain.MissingMandatoryValueException;
import tech.jhipster.lite.shared.error.domain.NotAfterTimeException;
import tech.jhipster.lite.shared.error.domain.NotBeforeTimeException;
import tech.jhipster.lite.shared.error.domain.NullElementInCollectionException;
import tech.jhipster.lite.shared.error.domain.NumberValueTooHighException;
import tech.jhipster.lite.shared.error.domain.NumberValueTooLowException;
import tech.jhipster.lite.shared.error.domain.StringTooLongException;
import tech.jhipster.lite.shared.error.domain.StringTooShortException;
import tech.jhipster.lite.shared.error.domain.StringWithWhitespacesException;
import tech.jhipster.lite.shared.error.domain.TooManyElementsException;

public class Assert {
    private Assert() {
    }

    public static void notNull(String field, Object input) {
        if (input == null) {
            throw MissingMandatoryValueException.forNullValue(field);
        }
    }

    public static void notBlank(String field, String input) {
        Assert.field(field, input).notBlank();
    }

    public static void notEmpty(String field, Collection<?> collection) {
        Assert.field(field, collection).notEmpty();
    }

    public static void noWhitespace(String field, String input) {
        Assert.field(field, input).noWhitespace();
    }

    public static StringAsserter field(String field, String input) {
        return new StringAsserter(field, input);
    }

    public static IntegerAsserter field(String field, Integer input) {
        return new IntegerAsserter(field, input);
    }

    public static LongAsserter field(String field, Long input) {
        return new LongAsserter(field, input);
    }

    public static FloatAsserter field(String field, Float input) {
        return new FloatAsserter(field, input);
    }

    public static DoubleAsserter field(String field, Double input) {
        return new DoubleAsserter(field, input);
    }

    public static BigDecimalAsserter field(String field, BigDecimal input) {
        return new BigDecimalAsserter(field, input);
    }

    public static <T> CollectionAsserter<T> field(String field, Collection<T> input) {
        return new CollectionAsserter<T>(field, input);
    }

    public static <T> ArrayAsserter<T> field(String field, T[] input) {
        return new ArrayAsserter<T>(field, input);
    }

    public static InstantAsserter field(String field, Instant input) {
        return new InstantAsserter(field, input);
    }

    public static class StringAsserter {
        public static final Pattern PATTERN_SPACE = Pattern.compile("\\s");
        private final String field;
        private final String value;

        private StringAsserter(String field, String value) {
            this.field = field;
            this.value = value;
        }

        public StringAsserter notNull() {
            Assert.notNull(this.field, this.value);
            return this;
        }

        public StringAsserter notBlank() {
            this.notNull();
            if (this.value.isBlank()) {
                throw MissingMandatoryValueException.forBlankValue(this.field);
            }
            return this;
        }

        public StringAsserter noWhitespace() {
            this.notNull();
            Matcher matcher = PATTERN_SPACE.matcher(this.value);
            if (matcher.find()) {
                throw new StringWithWhitespacesException(this.field);
            }
            return this;
        }

        public StringAsserter minLength(int length) {
            if (length <= 0 && this.value == null) {
                return this;
            }
            this.notNull();
            if (this.value.length() < length) {
                throw StringTooShortException.builder().field(this.field).value(this.value).minLength(length).build();
            }
            return this;
        }

        public StringAsserter maxLength(int length) {
            if (this.value == null) {
                return this;
            }
            if (this.value.length() > length) {
                throw StringTooLongException.builder().field(this.field).value(this.value).maxLength(length).build();
            }
            return this;
        }
    }

    public static class CollectionAsserter<T> {
        private final String field;
        private final Collection<T> value;

        private CollectionAsserter(String field, Collection<T> value) {
            this.field = field;
            this.value = value;
        }

        public CollectionAsserter<T> notNull() {
            Assert.notNull(this.field, this.value);
            return this;
        }

        public CollectionAsserter<T> notEmpty() {
            this.notNull();
            if (this.value.isEmpty()) {
                throw MissingMandatoryValueException.forEmptyValue(this.field);
            }
            return this;
        }

        public CollectionAsserter<T> maxSize(int maxSize) {
            if (maxSize <= 0 && this.value == null) {
                return this;
            }
            this.notNull();
            if (this.value.size() > maxSize) {
                throw TooManyElementsException.builder().field(this.field).maxSize(maxSize).size(this.value.size()).build();
            }
            return this;
        }

        public CollectionAsserter<T> noNullElement() {
            if (this.value == null) {
                return this;
            }
            if (this.value.stream().anyMatch(Objects::isNull)) {
                throw new NullElementInCollectionException(this.field);
            }
            return this;
        }
    }

    public static class IntegerAsserter {
        private final String field;
        private final Integer value;

        private IntegerAsserter(String field, Integer value) {
            this.field = field;
            this.value = value;
        }

        public IntegerAsserter positive() {
            return this.min(0);
        }

        public IntegerAsserter min(int minValue) {
            Assert.notNull(this.field, this.value);
            if (this.value < minValue) {
                throw NumberValueTooLowException.builder().field(this.field).minValue(String.valueOf(minValue)).value(String.valueOf(this.value)).build();
            }
            return this;
        }

        public IntegerAsserter max(int maxValue) {
            Assert.notNull(this.field, this.value);
            if (this.value > maxValue) {
                throw NumberValueTooHighException.builder().field(this.field).maxValue(String.valueOf(maxValue)).value(String.valueOf(this.value)).build();
            }
            return this;
        }
    }

    public static class LongAsserter {
        private final String field;
        private final Long value;

        private LongAsserter(String field, Long value) {
            this.field = field;
            this.value = value;
        }

        public LongAsserter positive() {
            return this.min(0L);
        }

        public LongAsserter min(long minValue) {
            Assert.notNull(this.field, this.value);
            if (this.value < minValue) {
                throw NumberValueTooLowException.builder().field(this.field).minValue(String.valueOf(minValue)).value(String.valueOf(this.value)).build();
            }
            return this;
        }

        public LongAsserter max(long maxValue) {
            Assert.notNull(this.field, this.value);
            if (this.value > maxValue) {
                throw NumberValueTooHighException.builder().field(this.field).maxValue(String.valueOf(maxValue)).value(String.valueOf(this.value)).build();
            }
            return this;
        }
    }

    public static class FloatAsserter {
        private final String field;
        private final Float value;

        private FloatAsserter(String field, Float value) {
            this.field = field;
            this.value = value;
        }

        public FloatAsserter positive() {
            return this.min(0.0f);
        }

        public FloatAsserter strictlyPositive() {
            return this.over(0.0f);
        }

        public FloatAsserter min(float minValue) {
            Assert.notNull(this.field, this.value);
            if (this.value.floatValue() < minValue) {
                throw this.tooLow(minValue);
            }
            return this;
        }

        public FloatAsserter over(float floor) {
            Assert.notNull(this.field, this.value);
            if (this.value.floatValue() <= floor) {
                throw this.tooLow(floor);
            }
            return this;
        }

        private NumberValueTooLowException tooLow(float floor) {
            return NumberValueTooLowException.builder().field(this.field).minValue(String.valueOf(floor)).value(String.valueOf(this.value)).build();
        }

        public FloatAsserter max(float maxValue) {
            Assert.notNull(this.field, this.value);
            if (this.value.floatValue() > maxValue) {
                throw this.tooHigh(maxValue);
            }
            return this;
        }

        public FloatAsserter under(float ceil) {
            Assert.notNull(this.field, this.value);
            if (this.value.floatValue() >= ceil) {
                throw this.tooHigh(ceil);
            }
            return this;
        }

        private NumberValueTooHighException tooHigh(float ceil) {
            return NumberValueTooHighException.builder().field(this.field).maxValue(String.valueOf(ceil)).value(String.valueOf(this.value)).build();
        }
    }

    public static class DoubleAsserter {
        private final String field;
        private final Double value;

        private DoubleAsserter(String field, Double value) {
            this.field = field;
            this.value = value;
        }

        public DoubleAsserter positive() {
            return this.min(0.0);
        }

        public DoubleAsserter strictlyPositive() {
            return this.over(0.0);
        }

        public DoubleAsserter min(double minValue) {
            Assert.notNull(this.field, this.value);
            if (this.value < minValue) {
                throw this.tooLow(minValue);
            }
            return this;
        }

        public DoubleAsserter over(double floor) {
            Assert.notNull(this.field, this.value);
            if (this.value <= floor) {
                throw this.tooLow(floor);
            }
            return this;
        }

        private NumberValueTooLowException tooLow(double floor) {
            return NumberValueTooLowException.builder().field(this.field).minValue(String.valueOf(floor)).value(String.valueOf(this.value)).build();
        }

        public DoubleAsserter max(double maxValue) {
            Assert.notNull(this.field, this.value);
            if (this.value > maxValue) {
                throw this.tooHigh(maxValue);
            }
            return this;
        }

        public DoubleAsserter under(double ceil) {
            Assert.notNull(this.field, this.value);
            if (this.value >= ceil) {
                throw this.tooHigh(ceil);
            }
            return this;
        }

        private NumberValueTooHighException tooHigh(double ceil) {
            return NumberValueTooHighException.builder().field(this.field).maxValue(String.valueOf(ceil)).value(String.valueOf(this.value)).build();
        }
    }

    public static class BigDecimalAsserter {
        private final String field;
        private final BigDecimal value;

        private BigDecimalAsserter(String field, BigDecimal value) {
            this.field = field;
            this.value = value;
        }

        public BigDecimalAsserter positive() {
            return this.min(0L);
        }

        public BigDecimalAsserter strictlyPositive() {
            return this.over(0L);
        }

        public BigDecimalAsserter min(long minValue) {
            return this.min(new BigDecimal(minValue));
        }

        public BigDecimalAsserter min(BigDecimal minValue) {
            this.notNull();
            Assert.notNull("minValue", minValue);
            if (this.value.compareTo(minValue) < 0) {
                throw this.tooLow(minValue);
            }
            return this;
        }

        public BigDecimalAsserter over(long floor) {
            return this.over(new BigDecimal(floor));
        }

        public BigDecimalAsserter over(BigDecimal floor) {
            this.notNull();
            Assert.notNull("floor", floor);
            if (this.value.compareTo(floor) <= 0) {
                throw this.tooLow(floor);
            }
            return this;
        }

        private NumberValueTooLowException tooLow(BigDecimal floor) {
            return NumberValueTooLowException.builder().field(this.field).minValue(String.valueOf(floor)).value(this.value.toPlainString()).build();
        }

        public BigDecimalAsserter max(long maxValue) {
            return this.max(new BigDecimal(maxValue));
        }

        public BigDecimalAsserter max(BigDecimal maxValue) {
            this.notNull();
            Assert.notNull("maxValue", maxValue);
            if (this.value.compareTo(maxValue) > 0) {
                throw this.tooHigh(maxValue);
            }
            return this;
        }

        public BigDecimalAsserter under(long ceil) {
            return this.under(new BigDecimal(ceil));
        }

        public BigDecimalAsserter under(BigDecimal ceil) {
            this.notNull();
            Assert.notNull("ceil", ceil);
            if (this.value.compareTo(ceil) >= 0) {
                throw this.tooHigh(ceil);
            }
            return this;
        }

        private NumberValueTooHighException tooHigh(BigDecimal ceil) {
            return NumberValueTooHighException.builder().field(this.field).maxValue(String.valueOf(ceil)).value(this.value.toPlainString()).build();
        }

        public BigDecimalAsserter notNull() {
            Assert.notNull(this.field, this.value);
            return this;
        }
    }

    public static class ArrayAsserter<T> {
        private final String field;
        private final T[] value;

        private ArrayAsserter(String field, T[] value) {
            this.field = field;
            this.value = value;
        }

        public ArrayAsserter<T> notNull() {
            Assert.notNull(this.field, this.value);
            return this;
        }

        public ArrayAsserter<T> notEmpty() {
            this.notNull();
            if (this.value.length == 0) {
                throw MissingMandatoryValueException.forEmptyValue(this.field);
            }
            return this;
        }

        public ArrayAsserter<T> maxSize(int maxSize) {
            if (maxSize <= 0 && this.value == null) {
                return this;
            }
            this.notNull();
            if (this.value.length > maxSize) {
                throw TooManyElementsException.builder().field(this.field).maxSize(maxSize).size(this.value.length).build();
            }
            return this;
        }

        public ArrayAsserter<T> noNullElement() {
            if (this.value == null) {
                return this;
            }
            if (Stream.of(this.value).anyMatch(Objects::isNull)) {
                throw new NullElementInCollectionException(this.field);
            }
            return this;
        }
    }

    public static class InstantAsserter {
        private static final String OTHER_FIELD_NAME = "other";
        private final String field;
        private final Instant value;

        private InstantAsserter(String field, Instant value) {
            this.field = field;
            this.value = value;
        }

        public InstantAsserter inFuture() {
            return this.afterOrAt(Instant.now());
        }

        public InstantAsserter after(Instant other) {
            this.notNull();
            Assert.notNull(OTHER_FIELD_NAME, other);
            if (this.value.compareTo(other) <= 0) {
                throw NotAfterTimeException.field(this.field, this.value).strictlyNotAfter(other);
            }
            return this;
        }

        public InstantAsserter afterOrAt(Instant other) {
            this.notNull();
            Assert.notNull(OTHER_FIELD_NAME, other);
            if (this.value.compareTo(other) < 0) {
                throw NotAfterTimeException.field(this.field, this.value).notAfter(other);
            }
            return this;
        }

        public InstantAsserter inPast() {
            return this.beforeOrAt(Instant.now());
        }

        public InstantAsserter before(Instant other) {
            this.notNull();
            Assert.notNull(OTHER_FIELD_NAME, other);
            if (this.value.compareTo(other) >= 0) {
                throw NotBeforeTimeException.field(this.field, this.value).strictlyNotBefore(other);
            }
            return this;
        }

        public InstantAsserter beforeOrAt(Instant other) {
            this.notNull();
            Assert.notNull(OTHER_FIELD_NAME, other);
            if (this.value.compareTo(other) > 0) {
                throw NotBeforeTimeException.field(this.field, this.value).notBefore(other);
            }
            return this;
        }

        public InstantAsserter notNull() {
            Assert.notNull(this.field, this.value);
            return this;
        }
    }
}

