/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.project.infrastructure.primary;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.lite.project.application.ProjectsApplicationService;
import tech.jhipster.lite.project.domain.ProjectPath;
import tech.jhipster.lite.project.domain.download.Project;
import tech.jhipster.lite.project.infrastructure.primary.RestProjectHistory;

@RestController
@Tag(name="Project")
@RequestMapping(value={"/api"})
class ProjectsResource {
    private final ProjectsApplicationService projects;

    public ProjectsResource(ProjectsApplicationService projects) {
        this.projects = projects;
    }

    @PostMapping(path={"/format-project"})
    @Operation(summary="Format the project")
    void formatProject(@Schema(description="Path of the project to format") @RequestParam(value="path") String path) {
        this.projects.format(new ProjectPath(path));
    }

    @Operation(summary="Download the project")
    @GetMapping(path={"/projects"}, produces={"application/octet-stream"})
    ResponseEntity<Resource> downloadProject(@Schema(description="Path of the project to download") @RequestParam(value="path") String path) {
        Project project = this.projects.get(new ProjectPath(path));
        String filename = project.name().filename();
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=" + filename})).header("X-Suggested-Filename", new String[]{filename})).contentType(MediaType.APPLICATION_OCTET_STREAM).contentLength(project.contentLength()).body((Object)new ByteArrayResource(project.content()));
    }

    @Operation(summary="Get project information")
    @GetMapping(path={"/projects"}, produces={"application/json"})
    ResponseEntity<RestProjectHistory> getProjectHistory(@Schema(description="Path of the project to get information for") @RequestParam(value="path") String path) {
        return ResponseEntity.ok((Object)RestProjectHistory.from(this.projects.getHistory(new ProjectPath(path))));
    }
}

