/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.project.domain.history;

import java.time.Instant;
import java.util.Map;
import tech.jhipster.lite.project.domain.history.ModuleParameters;
import tech.jhipster.lite.project.domain.history.ModuleSlug;
import tech.jhipster.lite.shared.error.domain.Assert;

public class ProjectAction {
    private final ModuleSlug module;
    private final Instant date;
    private final ModuleParameters parameters;

    private ProjectAction(ProjectActionBuilder builder) {
        Assert.notNull("module", builder.module);
        Assert.notNull("date", builder.date);
        Assert.notNull("parameters", builder.parameters);
        this.module = builder.module;
        this.date = builder.date;
        this.parameters = builder.parameters;
    }

    public static ProjectActionModuleBuilder builder() {
        return new ProjectActionBuilder();
    }

    public ModuleSlug module() {
        return this.module;
    }

    public Instant date() {
        return this.date;
    }

    public ModuleParameters parameters() {
        return this.parameters;
    }

    private static class ProjectActionBuilder
    implements ProjectActionModuleBuilder,
    ProjectActionDateBuilder,
    ProjectActionParametersBuilder {
        private ModuleSlug module;
        private Instant date;
        private ModuleParameters parameters;

        private ProjectActionBuilder() {
        }

        @Override
        public ProjectActionDateBuilder module(ModuleSlug module) {
            this.module = module;
            return this;
        }

        @Override
        public ProjectActionParametersBuilder date(Instant date) {
            this.date = date;
            return this;
        }

        @Override
        public ProjectAction parameters(ModuleParameters properties) {
            this.parameters = properties;
            return new ProjectAction(this);
        }
    }

    public static interface ProjectActionParametersBuilder {
        public ProjectAction parameters(ModuleParameters var1);

        default public ProjectAction parameters(Map<String, Object> properties) {
            return this.parameters(new ModuleParameters(properties));
        }
    }

    public static interface ProjectActionDateBuilder {
        public ProjectActionParametersBuilder date(Instant var1);
    }

    public static interface ProjectActionModuleBuilder {
        public ProjectActionDateBuilder module(ModuleSlug var1);

        default public ProjectActionDateBuilder module(String module) {
            return this.module(new ModuleSlug(module));
        }
    }
}

