/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary.javadependency.gradle;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.NotImplementedException;
import tech.jhipster.lite.module.domain.Indentation;
import tech.jhipster.lite.module.domain.JHipsterProjectFilePath;
import tech.jhipster.lite.module.domain.gradleplugin.GradleCommunityPlugin;
import tech.jhipster.lite.module.domain.gradleplugin.GradleCorePlugin;
import tech.jhipster.lite.module.domain.gradleplugin.GradlePlugin;
import tech.jhipster.lite.module.domain.gradleplugin.GradlePluginConfiguration;
import tech.jhipster.lite.module.domain.javabuild.DependencySlug;
import tech.jhipster.lite.module.domain.javabuild.command.AddDirectJavaDependency;
import tech.jhipster.lite.module.domain.javabuild.command.AddDirectMavenPlugin;
import tech.jhipster.lite.module.domain.javabuild.command.AddGradlePlugin;
import tech.jhipster.lite.module.domain.javabuild.command.AddJavaBuildProfile;
import tech.jhipster.lite.module.domain.javabuild.command.AddJavaDependencyManagement;
import tech.jhipster.lite.module.domain.javabuild.command.AddMavenBuildExtension;
import tech.jhipster.lite.module.domain.javabuild.command.AddMavenPluginManagement;
import tech.jhipster.lite.module.domain.javabuild.command.RemoveDirectJavaDependency;
import tech.jhipster.lite.module.domain.javabuild.command.RemoveJavaDependencyManagement;
import tech.jhipster.lite.module.domain.javabuild.command.SetBuildProperty;
import tech.jhipster.lite.module.domain.javabuild.command.SetVersion;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyVersion;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;
import tech.jhipster.lite.module.domain.replacement.ContentReplacers;
import tech.jhipster.lite.module.domain.replacement.MandatoryFileReplacer;
import tech.jhipster.lite.module.domain.replacement.MandatoryReplacer;
import tech.jhipster.lite.module.domain.replacement.RegexNeedleBeforeReplacer;
import tech.jhipster.lite.module.domain.replacement.RegexReplacer;
import tech.jhipster.lite.module.domain.replacement.ReplacementCondition;
import tech.jhipster.lite.module.infrastructure.secondary.FileSystemReplacer;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.JavaDependenciesCommandHandler;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.gradle.GradleDependencyScope;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.gradle.VersionsCatalog;
import tech.jhipster.lite.shared.error.domain.Assert;

public class GradleCommandHandler
implements JavaDependenciesCommandHandler {
    private static final String COMMAND = "command";
    private static final String NOT_YET_IMPLEMENTED = "Not yet implemented";
    private static final String BUILD_GRADLE_FILE = "build.gradle.kts";
    private static final Pattern GRADLE_PLUGIN_NEEDLE = Pattern.compile("^\\s+// jhipster-needle-gradle-plugins$", 8);
    private static final Pattern GRADLE_PLUGIN_PROJECT_EXTENSION_CONFIGURATION_NEEDLE = Pattern.compile("^// jhipster-needle-gradle-plugins-configurations$", 8);
    private static final Pattern GRADLE_DEPENDENCY_NEEDLE = Pattern.compile("^\\s+// jhipster-needle-gradle-dependencies$", 8);
    private static final Pattern GRADLE_TEST_DEPENDENCY_NEEDLE = Pattern.compile("^\\s+// jhipster-needle-gradle-test-dependencies$", 8);
    private final Indentation indentation;
    private final JHipsterProjectFolder projectFolder;
    private final VersionsCatalog versionsCatalog;
    private final FileSystemReplacer fileReplacer = new FileSystemReplacer();

    public GradleCommandHandler(Indentation indentation, JHipsterProjectFolder projectFolder) {
        Assert.notNull("indentation", indentation);
        Assert.notNull("projectFolder", projectFolder);
        this.indentation = indentation;
        this.projectFolder = projectFolder;
        this.versionsCatalog = new VersionsCatalog(projectFolder);
    }

    @Override
    public void handle(SetVersion command) {
        Assert.notNull(COMMAND, command);
        this.versionsCatalog.setVersion(command.version());
    }

    @Override
    public void handle(AddDirectJavaDependency command) {
        Assert.notNull(COMMAND, command);
        this.versionsCatalog.addLibrary(command.dependency());
        this.addDependencyToBuildGradle(command.dependency());
    }

    private void addDependencyToBuildGradle(JavaDependency dependency) {
        GradleDependencyScope gradleScope = GradleCommandHandler.gradleDependencyScope(dependency);
        String libraryVersionCatalogReference = GradleCommandHandler.versionCatalogReference(dependency);
        String dependencyDeclaration = dependency.scope() == JavaDependencyScope.IMPORT ? "%s%s(platform(%s))".formatted(this.indentation.times(1), gradleScope.command(), libraryVersionCatalogReference) : "%s%s(%s)".formatted(this.indentation.times(1), gradleScope.command(), libraryVersionCatalogReference);
        MandatoryReplacer replacer = new MandatoryReplacer(new RegexNeedleBeforeReplacer((contentBeforeReplacement, newText) -> !contentBeforeReplacement.contains(newText), gradleScope == GradleDependencyScope.TEST_IMPLEMENTATION ? GRADLE_TEST_DEPENDENCY_NEEDLE : GRADLE_DEPENDENCY_NEEDLE), dependencyDeclaration);
        this.fileReplacer.handle(this.projectFolder, ContentReplacers.of(new MandatoryFileReplacer(new JHipsterProjectFilePath(BUILD_GRADLE_FILE), replacer)));
    }

    private static String versionCatalogReference(JavaDependency dependency) {
        return "libs.%s".formatted(GradleCommandHandler.applyVersionCatalogReferenceConvention(VersionsCatalog.libraryAlias(dependency)));
    }

    private static String applyVersionCatalogReferenceConvention(String rawVersionCatalogReference) {
        return rawVersionCatalogReference.replace("-", ".");
    }

    private static GradleDependencyScope gradleDependencyScope(JavaDependency dependency) {
        return switch (dependency.scope()) {
            case JavaDependencyScope.TEST -> GradleDependencyScope.TEST_IMPLEMENTATION;
            case JavaDependencyScope.PROVIDED -> GradleDependencyScope.COMPILE_ONLY;
            case JavaDependencyScope.RUNTIME -> GradleDependencyScope.RUNTIME_ONLY;
            default -> GradleDependencyScope.IMPLEMENTATION;
        };
    }

    @Override
    public void handle(RemoveDirectJavaDependency command) {
        this.versionsCatalog.retrieveDependencySlugsFrom(command.dependency()).forEach(this::removeDependencyFromBuildGradle);
        this.versionsCatalog.removeLibrary(command.dependency());
    }

    private void removeDependencyFromBuildGradle(DependencySlug dependencySlug) {
        String scopePattern = Stream.of(GradleDependencyScope.values()).map(GradleDependencyScope::command).collect(Collectors.joining("|", "(", ")"));
        Pattern dependencyLinePattern = Pattern.compile("^\\s+%s\\((platform\\()?libs\\.%s\\)?\\)$".formatted(scopePattern, dependencySlug.slug().replace("-", "\\.")), 8);
        MandatoryReplacer replacer = new MandatoryReplacer(new RegexReplacer(ReplacementCondition.always(), dependencyLinePattern), "");
        this.fileReplacer.handle(this.projectFolder, ContentReplacers.of(new MandatoryFileReplacer(new JHipsterProjectFilePath(BUILD_GRADLE_FILE), replacer)));
    }

    @Override
    public void handle(RemoveJavaDependencyManagement command) {
        this.versionsCatalog.retrieveDependencySlugsFrom(command.dependency()).forEach(this::removeDependencyFromBuildGradle);
        this.versionsCatalog.removeLibrary(command.dependency());
    }

    @Override
    public void handle(AddJavaDependencyManagement command) {
        this.versionsCatalog.addLibrary(command.dependency());
        this.addDependencyToBuildGradle(command.dependency());
    }

    @Override
    public void handle(AddDirectMavenPlugin command) {
    }

    @Override
    public void handle(AddMavenPluginManagement command) {
    }

    @Override
    public void handle(SetBuildProperty command) {
        throw new NotImplementedException(NOT_YET_IMPLEMENTED);
    }

    @Override
    public void handle(AddMavenBuildExtension command) {
    }

    @Override
    public void handle(AddJavaBuildProfile addJavaBuildProfile) {
        throw new NotImplementedException(NOT_YET_IMPLEMENTED);
    }

    @Override
    public void handle(AddGradlePlugin command) {
        Assert.notNull(COMMAND, command);
        GradlePlugin gradlePlugin = command.plugin();
        Objects.requireNonNull(gradlePlugin);
        GradlePlugin gradlePlugin2 = gradlePlugin;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GradleCorePlugin.class, GradleCommunityPlugin.class}, (Object)gradlePlugin2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                GradleCorePlugin plugin = (GradleCorePlugin)gradlePlugin2;
                this.declarePlugin(plugin.id().get());
                break;
            }
            case 1: {
                GradleCommunityPlugin plugin = (GradleCommunityPlugin)gradlePlugin2;
                this.declarePlugin("alias(libs.plugins.%s)".formatted(GradleCommandHandler.applyVersionCatalogReferenceConvention(VersionsCatalog.pluginAlias(plugin))));
                this.versionsCatalog.addPlugin(plugin);
            }
        }
        command.plugin().configuration().ifPresent(this::addPluginConfiguration);
        command.toolVersion().ifPresent(version -> this.handle(new SetVersion((JavaDependencyVersion)version)));
        command.pluginVersion().ifPresent(version -> this.handle(new SetVersion((JavaDependencyVersion)version)));
    }

    private void declarePlugin(String pluginDeclaration) {
        MandatoryReplacer replacer = new MandatoryReplacer(new RegexNeedleBeforeReplacer((contentBeforeReplacement, newText) -> !contentBeforeReplacement.contains(newText), GRADLE_PLUGIN_NEEDLE), this.indentation.times(1) + pluginDeclaration);
        this.fileReplacer.handle(this.projectFolder, ContentReplacers.of(new MandatoryFileReplacer(new JHipsterProjectFilePath(BUILD_GRADLE_FILE), replacer)));
    }

    private void addPluginConfiguration(GradlePluginConfiguration pluginConfiguration) {
        MandatoryReplacer replacer = new MandatoryReplacer(new RegexNeedleBeforeReplacer((contentBeforeReplacement, newText) -> !contentBeforeReplacement.contains(newText), GRADLE_PLUGIN_PROJECT_EXTENSION_CONFIGURATION_NEEDLE), "\n" + pluginConfiguration.get());
        this.fileReplacer.handle(this.projectFolder, ContentReplacers.of(new MandatoryFileReplacer(new JHipsterProjectFilePath(BUILD_GRADLE_FILE), replacer)));
    }
}

