/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.springframework.stereotype.Repository;
import tech.jhipster.lite.module.domain.GeneratedProjectRepository;
import tech.jhipster.lite.module.domain.JHipsterFileMatcher;
import tech.jhipster.lite.module.domain.JHipsterProjectFilePath;
import tech.jhipster.lite.module.domain.JHipsterProjectFilesPaths;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.shared.error.domain.GeneratorException;

@Repository
class FileSystemGeneratedProjectRepository
implements GeneratedProjectRepository {
    FileSystemGeneratedProjectRepository() {
    }

    @Override
    public JHipsterProjectFilesPaths list(JHipsterProjectFolder folder, JHipsterFileMatcher files) {
        JHipsterProjectFilesPaths jHipsterProjectFilesPaths;
        block8: {
            Assert.notNull("folder", folder);
            Assert.notNull("files", files);
            Stream<Path> content = Files.walk(Paths.get(folder.get(), new String[0]), new FileVisitOption[0]);
            try {
                jHipsterProjectFilesPaths = new JHipsterProjectFilesPaths(content.filter(file -> !Files.isDirectory(file, new LinkOption[0])).map(Path::toString).map(file -> file.substring(folder.get().length() + 1)).map(JHipsterProjectFilePath::new).filter(files::match).toList());
                if (content == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw GeneratorException.technicalError(e.getMessage(), e);
                }
            }
            content.close();
        }
        return jHipsterProjectFilesPaths;
    }
}

