/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.resource;

import java.util.regex.Pattern;
import tech.jhipster.lite.module.domain.resource.InvalidJHipsterModuleTagException;
import tech.jhipster.lite.shared.error.domain.Assert;

public record JHipsterModuleTag(String tag) {
    private static final Pattern TAG_FORMAT = Pattern.compile("^[a-z0-9-]+$");

    public JHipsterModuleTag {
        Assert.field("tag", tag).notNull().noWhitespace().maxLength(15);
        JHipsterModuleTag.assertFormat(tag);
    }

    private static void assertFormat(String tag) {
        if (JHipsterModuleTag.invalidFormat(tag)) {
            throw new InvalidJHipsterModuleTagException(tag);
        }
    }

    private static boolean invalidFormat(String slug) {
        return !TAG_FORMAT.matcher(slug).matches();
    }

    public String get() {
        return this.tag();
    }
}

