/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.resource;

import java.util.Optional;
import tech.jhipster.lite.module.domain.properties.JHipsterPropertyDefaultValue;
import tech.jhipster.lite.module.domain.properties.JHipsterPropertyDescription;
import tech.jhipster.lite.module.domain.properties.JHipsterPropertyKey;
import tech.jhipster.lite.module.domain.properties.JHipsterPropertyType;
import tech.jhipster.lite.shared.error.domain.Assert;

public class JHipsterModulePropertyDefinition {
    private final JHipsterPropertyType type;
    private final boolean mandatory;
    private final JHipsterPropertyKey key;
    private final Optional<JHipsterPropertyDescription> description;
    private final Optional<JHipsterPropertyDefaultValue> defaultValue;
    private final int order;

    private JHipsterModulePropertyDefinition(JHipsterModulePropertyDefinitionBuilder builder) {
        Assert.notNull("type", (Object)builder.type);
        Assert.notBlank("key", builder.key);
        this.type = builder.type;
        this.mandatory = builder.mandatory;
        this.key = new JHipsterPropertyKey(builder.key);
        this.description = JHipsterPropertyDescription.of(builder.description);
        this.defaultValue = JHipsterPropertyDefaultValue.of(builder.defaultValue);
        this.order = builder.order;
    }

    public static JHipsterModulePropertyDefinition basePackageProperty() {
        return JHipsterModulePropertyDefinition.mandatoryStringProperty("packageName").description("Base java package").defaultValue("com.mycompany.myapp").order(-300).build();
    }

    public static JHipsterModulePropertyDefinition projectNameProperty() {
        return JHipsterModulePropertyDefinition.mandatoryStringProperty("projectName").description("Project full name").defaultValue("JHipster Sample Application").order(-200).build();
    }

    static JHipsterModulePropertyDefinition projectBaseNameProperty() {
        return JHipsterModulePropertyDefinition.mandatoryStringProperty("baseName").description("Project short name (only letters and numbers)").defaultValue("jhipsterSampleApplication").order(-100).build();
    }

    static JHipsterModulePropertyDefinition serverPortProperty() {
        return JHipsterModulePropertyDefinition.mandatoryIntegerProperty("serverPort").description("Server port").defaultValue("8080").order(-50).build();
    }

    public static JHipsterModulePropertyDefinition endOfLineProperty() {
        return JHipsterModulePropertyDefinition.optionalStringProperty("endOfLine").description("Type of line break (lf or crlf)").defaultValue("lf").order(100).build();
    }

    public static JHipsterModulePropertyDefinition indentationProperty() {
        return JHipsterModulePropertyDefinition.optionalIntegerProperty("indentSize").description("Number of spaces in indentation").defaultValue("2").order(500).build();
    }

    public static JHipsterModulePropertyDefinition configurationFormatProperty() {
        return JHipsterModulePropertyDefinition.optionalStringProperty("configurationFormat").description("Format of the configuration files (yaml or properties)").defaultValue("yaml").order(500).build();
    }

    public static JHipsterModulePropertyDefinitionOptionalFieldsBuilder mandatoryStringProperty(String key) {
        return JHipsterModulePropertyDefinition.builder().type(JHipsterPropertyType.STRING).mandatory(true).key(key);
    }

    public static JHipsterModulePropertyDefinitionOptionalFieldsBuilder optionalStringProperty(String key) {
        return JHipsterModulePropertyDefinition.builder().type(JHipsterPropertyType.STRING).mandatory(false).key(key);
    }

    public static JHipsterModulePropertyDefinitionOptionalFieldsBuilder mandatoryIntegerProperty(String key) {
        return JHipsterModulePropertyDefinition.builder().type(JHipsterPropertyType.INTEGER).mandatory(true).key(key);
    }

    public static JHipsterModulePropertyDefinitionOptionalFieldsBuilder optionalIntegerProperty(String key) {
        return JHipsterModulePropertyDefinition.builder().type(JHipsterPropertyType.INTEGER).mandatory(false).key(key);
    }

    public static JHipsterModulePropertyDefinitionOptionalFieldsBuilder mandatoryBooleanProperty(String key) {
        return JHipsterModulePropertyDefinition.builder().type(JHipsterPropertyType.BOOLEAN).mandatory(true).key(key);
    }

    public static JHipsterModulePropertyDefinitionOptionalFieldsBuilder optionalBooleanProperty(String key) {
        return JHipsterModulePropertyDefinition.builder().type(JHipsterPropertyType.BOOLEAN).mandatory(false).key(key);
    }

    public static JHipsterModulePropertyDefinitionTypeBuilder builder() {
        return new JHipsterModulePropertyDefinitionBuilder();
    }

    public JHipsterPropertyType type() {
        return this.type;
    }

    public JHipsterPropertyKey key() {
        return this.key;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public Optional<JHipsterPropertyDescription> description() {
        return this.description;
    }

    public Optional<JHipsterPropertyDefaultValue> defaultValue() {
        return this.defaultValue;
    }

    public int order() {
        return this.order;
    }

    private static class JHipsterModulePropertyDefinitionBuilder
    implements JHipsterModulePropertyDefinitionTypeBuilder,
    JHipsterModulePropertyDefinitionOptionalityBuilder,
    JHipsterModulePropertyDefinitionKeyBuilder,
    JHipsterModulePropertyDefinitionOptionalFieldsBuilder {
        private JHipsterPropertyType type;
        private boolean mandatory;
        private String key;
        private String description;
        private String defaultValue;
        private int order;

        private JHipsterModulePropertyDefinitionBuilder() {
        }

        @Override
        public JHipsterModulePropertyDefinitionOptionalityBuilder type(JHipsterPropertyType type) {
            this.type = type;
            return this;
        }

        @Override
        public JHipsterModulePropertyDefinitionKeyBuilder mandatory(boolean mandatory) {
            this.mandatory = mandatory;
            return this;
        }

        @Override
        public JHipsterModulePropertyDefinitionOptionalFieldsBuilder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public JHipsterModulePropertyDefinitionOptionalFieldsBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public JHipsterModulePropertyDefinitionOptionalFieldsBuilder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Override
        public JHipsterModulePropertyDefinitionOptionalFieldsBuilder order(int order) {
            this.order = order;
            return this;
        }

        @Override
        public JHipsterModulePropertyDefinition build() {
            return new JHipsterModulePropertyDefinition(this);
        }
    }

    public static interface JHipsterModulePropertyDefinitionOptionalFieldsBuilder {
        public JHipsterModulePropertyDefinitionOptionalFieldsBuilder description(String var1);

        public JHipsterModulePropertyDefinitionOptionalFieldsBuilder defaultValue(String var1);

        public JHipsterModulePropertyDefinitionOptionalFieldsBuilder order(int var1);

        public JHipsterModulePropertyDefinition build();
    }

    public static interface JHipsterModulePropertyDefinitionTypeBuilder {
        public JHipsterModulePropertyDefinitionOptionalityBuilder type(JHipsterPropertyType var1);
    }

    public static interface JHipsterModulePropertyDefinitionOptionalityBuilder {
        public JHipsterModulePropertyDefinitionKeyBuilder mandatory(boolean var1);
    }

    public static interface JHipsterModulePropertyDefinitionKeyBuilder {
        public JHipsterModulePropertyDefinitionOptionalFieldsBuilder key(String var1);
    }
}

