/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.mavenplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import tech.jhipster.lite.module.domain.javabuild.command.AddDirectMavenPlugin;
import tech.jhipster.lite.module.domain.javabuild.command.AddMavenPlugin;
import tech.jhipster.lite.module.domain.javabuild.command.AddMavenPluginManagement;
import tech.jhipster.lite.module.domain.javabuild.command.AddMavenPluginOptionalBuilder;
import tech.jhipster.lite.module.domain.javabuild.command.AddMavenPluginPluginBuilder;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommands;
import tech.jhipster.lite.module.domain.javabuildprofile.BuildProfileId;
import tech.jhipster.lite.module.domain.javadependency.JavaDependenciesVersions;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyVersion;
import tech.jhipster.lite.module.domain.javadependency.ProjectJavaDependencies;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPlugin;
import tech.jhipster.lite.shared.error.domain.Assert;

public class JHipsterModuleMavenPlugins {
    private final Collection<MavenPlugin> pluginsManagement;
    private final Collection<MavenPlugin> plugins;

    private JHipsterModuleMavenPlugins(JHipsterModuleMavenPluginsBuilder<?> builder) {
        this.pluginsManagement = builder.pluginsManagement;
        this.plugins = builder.plugins;
    }

    public static <T> JHipsterModuleMavenPluginsBuilder<T> builder(T parentModuleBuilder) {
        return new JHipsterModuleMavenPluginsBuilder<T>(parentModuleBuilder);
    }

    public JavaBuildCommands buildChanges(JavaDependenciesVersions versions, ProjectJavaDependencies projectJavaDependencies) {
        return this.buildChanges(versions, projectJavaDependencies, Optional.empty());
    }

    public JavaBuildCommands buildChanges(JavaDependenciesVersions versions, ProjectJavaDependencies projectJavaDependencies, BuildProfileId buildProfile) {
        Assert.notNull("buildProfile", buildProfile);
        return this.buildChanges(versions, projectJavaDependencies, Optional.of(buildProfile));
    }

    private JavaBuildCommands buildChanges(JavaDependenciesVersions versions, ProjectJavaDependencies projectJavaDependencies, Optional<BuildProfileId> buildProfile) {
        Assert.notNull("versions", versions);
        Assert.notNull("projectJavaDependencies", projectJavaDependencies);
        Stream managementCommands = this.pluginsManagement.stream().map(JHipsterModuleMavenPlugins.toAddMavenPlugin(versions, projectJavaDependencies, buildProfile, AddMavenPluginManagement::builder));
        Stream pluginsCommands = this.plugins.stream().map(JHipsterModuleMavenPlugins.toAddMavenPlugin(versions, projectJavaDependencies, buildProfile, AddDirectMavenPlugin::builder));
        return new JavaBuildCommands(Stream.concat(managementCommands, pluginsCommands).toList());
    }

    private static <C extends AddMavenPlugin> Function<MavenPlugin, C> toAddMavenPlugin(JavaDependenciesVersions versions, ProjectJavaDependencies projectDependencies, Optional<BuildProfileId> buildProfile, Supplier<AddMavenPluginPluginBuilder<C>> builderFactory) {
        return plugin -> {
            AddMavenPluginOptionalBuilder commandBuilder = ((AddMavenPluginPluginBuilder)builderFactory.get()).plugin((MavenPlugin)plugin);
            buildProfile.ifPresent(commandBuilder::buildProfile);
            plugin.dependencies().stream().flatMap(JHipsterModuleMavenPlugins.toDependencyVersion(versions, projectDependencies)).forEach(commandBuilder::addDependencyVersion);
            plugin.versionSlug().map(versions::get).ifPresent(commandBuilder::pluginVersion);
            return commandBuilder.build();
        };
    }

    private static Function<JavaDependency, Stream<JavaDependencyVersion>> toDependencyVersion(JavaDependenciesVersions versions, ProjectJavaDependencies projectDependencies) {
        return dependency -> dependency.version().flatMap(JavaDependency.toVersion(versions, projectDependencies)).stream();
    }

    public static class JHipsterModuleMavenPluginsBuilder<T> {
        private final T parentModuleBuilder;
        private final Collection<MavenPlugin> pluginsManagement = new ArrayList<MavenPlugin>();
        private final Collection<MavenPlugin> plugins = new ArrayList<MavenPlugin>();

        private JHipsterModuleMavenPluginsBuilder(T parentModuleBuilder) {
            Assert.notNull("parentModuleBuilder", parentModuleBuilder);
            this.parentModuleBuilder = parentModuleBuilder;
        }

        public JHipsterModuleMavenPluginsBuilder<T> pluginManagement(MavenPlugin pluginManagement) {
            Assert.notNull("pluginManagement", pluginManagement);
            this.pluginsManagement.add(pluginManagement);
            return this;
        }

        public JHipsterModuleMavenPluginsBuilder<T> plugin(MavenPlugin plugin) {
            Assert.notNull("plugin", plugin);
            this.plugins.add(plugin);
            return this;
        }

        public T and() {
            return this.parentModuleBuilder;
        }

        public JHipsterModuleMavenPlugins build() {
            return new JHipsterModuleMavenPlugins(this);
        }
    }
}

