/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.landscape;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import tech.jhipster.lite.module.domain.JHipsterModuleSlug;
import tech.jhipster.lite.module.domain.JHipsterSlug;
import tech.jhipster.lite.module.domain.landscape.InvalidLandscapeException;
import tech.jhipster.lite.module.domain.landscape.JHipsterLandscapeDependencies;
import tech.jhipster.lite.module.domain.landscape.JHipsterLandscapeDependency;
import tech.jhipster.lite.module.domain.landscape.JHipsterLandscapeElement;
import tech.jhipster.lite.module.domain.landscape.JHipsterLandscapeFeature;
import tech.jhipster.lite.module.domain.landscape.JHipsterLandscapeLevel;
import tech.jhipster.lite.module.domain.landscape.JHipsterLandscapeLevels;
import tech.jhipster.lite.module.domain.landscape.JHipsterLandscapeModule;
import tech.jhipster.lite.module.domain.resource.JHipsterModulesResources;

public class JHipsterLandscape {
    private final JHipsterLandscapeLevels levels;

    private JHipsterLandscape(JHipsterLandscapeLevels levels) {
        this.levels = levels;
    }

    public static JHipsterLandscape from(JHipsterModulesResources resources) {
        JHipsterLandscape.assertNoDuplicatedSlug(resources);
        return new JHipsterLandscape(JHipsterLandscapeLevels.builder().resources(resources).build()).withoutNestedDependencies().sorted();
    }

    private static void assertNoDuplicatedSlug(JHipsterModulesResources resources) {
        JHipsterLandscape.duplicatedSlug(resources).ifPresent(JHipsterLandscape.throwForDuplicatedSlug());
    }

    private static Optional<String> duplicatedSlug(JHipsterModulesResources resources) {
        List<String> featureSlugs = JHipsterLandscape.allFeatureSlugs(resources);
        return resources.stream().map(resource -> resource.slug().get()).filter(featureSlugs::contains).findFirst();
    }

    private static List<String> allFeatureSlugs(JHipsterModulesResources resources) {
        return resources.stream().flatMap(resource -> resource.organization().feature().stream()).map(JHipsterSlug::get).toList();
    }

    private static Consumer<String> throwForDuplicatedSlug() {
        return slug -> {
            throw InvalidLandscapeException.duplicatedSlug(slug);
        };
    }

    private JHipsterLandscape withoutNestedDependencies() {
        return new JHipsterLandscape(new JHipsterLandscapeLevels(this.nestedDependenciesFreeLevels()));
    }

    private List<JHipsterLandscapeLevel> nestedDependenciesFreeLevels() {
        return this.levels.stream().map(this.toLevelsWithoutNestedDependencies()).toList();
    }

    private Function<JHipsterLandscapeLevel, JHipsterLandscapeLevel> toLevelsWithoutNestedDependencies() {
        return level -> new JHipsterLandscapeLevel(level.elements().stream().map(this::toElementWithoutNestedDependencies).toList());
    }

    private JHipsterLandscapeElement toElementWithoutNestedDependencies(JHipsterLandscapeElement element) {
        JHipsterLandscapeElement jHipsterLandscapeElement = element;
        Objects.requireNonNull(jHipsterLandscapeElement);
        JHipsterLandscapeElement jHipsterLandscapeElement2 = jHipsterLandscapeElement;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JHipsterLandscapeModule.class, JHipsterLandscapeFeature.class}, (Object)jHipsterLandscapeElement2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                JHipsterLandscapeModule module = (JHipsterLandscapeModule)jHipsterLandscapeElement2;
                yield this.moduleWithoutNestedDependencies(module);
            }
            case 1 -> {
                JHipsterLandscapeFeature feature;
                yield feature = (JHipsterLandscapeFeature)jHipsterLandscapeElement2;
            }
        };
    }

    private JHipsterLandscapeModule moduleWithoutNestedDependencies(JHipsterLandscapeModule module) {
        List<JHipsterLandscapeDependency> knownDependencies = this.knownDependencies(module);
        return JHipsterLandscapeModule.builder().module(module.slug()).operation(module.operation()).propertiesDefinition(module.propertiesDefinition()).dependencies(this.dependenciesWithoutNested(module, knownDependencies));
    }

    private List<JHipsterLandscapeDependency> knownDependencies(JHipsterLandscapeModule module) {
        return module.dependencies().map(this.toKnownDependencies()).orElse(List.of());
    }

    private Function<JHipsterLandscapeDependencies, List<JHipsterLandscapeDependency>> toKnownDependencies() {
        return dependencies -> dependencies.stream().flatMap(dependency -> this.allDependenciesOf(dependency.slug())).toList();
    }

    private List<JHipsterLandscapeDependency> dependenciesWithoutNested(JHipsterLandscapeModule module, List<JHipsterLandscapeDependency> knownDependencies) {
        return module.dependencies().map(this.toDependenciesWithoutNested(knownDependencies)).orElse(null);
    }

    private Function<JHipsterLandscapeDependencies, List<JHipsterLandscapeDependency>> toDependenciesWithoutNested(List<JHipsterLandscapeDependency> knownDependencies) {
        return dependencies -> dependencies.stream().filter(dependency -> !knownDependencies.contains(dependency)).toList();
    }

    private Stream<JHipsterLandscapeDependency> allDependenciesOf(JHipsterSlug slug) {
        return this.levels.stream().flatMap(level -> level.elements().stream()).filter(element -> element.slug().equals(slug)).flatMap(element -> element.dependencies().map(JHipsterLandscapeDependencies::stream).orElse(Stream.of(new JHipsterLandscapeDependency[0])));
    }

    public Collection<JHipsterModuleSlug> sort(Collection<JHipsterModuleSlug> modules) {
        return this.levels.stream().flatMap(this.toLevelModules(modules)).toList();
    }

    private Function<JHipsterLandscapeLevel, Stream<JHipsterModuleSlug>> toLevelModules(Collection<JHipsterModuleSlug> modules) {
        return level -> modules.stream().filter(this.inLevel((JHipsterLandscapeLevel)level)).sorted();
    }

    private Predicate<JHipsterModuleSlug> inLevel(JHipsterLandscapeLevel level) {
        return module -> level.elements().stream().flatMap(JHipsterLandscapeElement::allModules).map(JHipsterLandscapeElement::slug).anyMatch(levelElement -> levelElement.equals(module));
    }

    private JHipsterLandscape sorted() {
        return new JHipsterLandscape(new JHipsterLandscapeLevels(this.levels.stream().map(this.toSortedLevel()).toList()));
    }

    private Function<JHipsterLandscapeLevel, JHipsterLandscapeLevel> toSortedLevel() {
        Comparator<JHipsterLandscapeElement> levelComparator = Comparator.comparing(this::linksCount).thenComparing(element -> element.slug().get());
        return level -> new JHipsterLandscapeLevel(level.elements().stream().sorted(levelComparator).toList());
    }

    private long linksCount(JHipsterLandscapeElement element) {
        JHipsterLandscapeElement jHipsterLandscapeElement = element;
        Objects.requireNonNull(jHipsterLandscapeElement);
        JHipsterLandscapeElement jHipsterLandscapeElement2 = jHipsterLandscapeElement;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JHipsterLandscapeFeature.class, JHipsterLandscapeModule.class}, (Object)jHipsterLandscapeElement2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                JHipsterLandscapeFeature feature = (JHipsterLandscapeFeature)jHipsterLandscapeElement2;
                yield this.featureLinksCount(feature);
            }
            case 1 -> {
                JHipsterLandscapeModule module = (JHipsterLandscapeModule)jHipsterLandscapeElement2;
                yield this.moduleLinksCount(module);
            }
        };
    }

    private long featureLinksCount(JHipsterLandscapeFeature feature) {
        return this.elementDependantModulesCount(feature) + this.dependantModulesCount(feature);
    }

    private long dependantModulesCount(JHipsterLandscapeFeature feature) {
        return feature.modules().stream().mapToLong(this::moduleLinksCount).sum();
    }

    private long moduleLinksCount(JHipsterLandscapeModule module) {
        return this.elementDependantModulesCount(module) + this.dependenciesCount(module);
    }

    private long elementDependantModulesCount(JHipsterLandscapeElement element) {
        return this.levels.stream().flatMap(level -> level.elements().stream()).filter(JHipsterLandscapeModule.class::isInstance).map(JHipsterLandscapeModule.class::cast).flatMap(this.toDependencies()).filter(dependency -> dependency.slug().equals(element.slug())).count();
    }

    private Function<JHipsterLandscapeModule, Stream<JHipsterLandscapeDependency>> toDependencies() {
        return landscapeModule -> landscapeModule.dependencies().map(JHipsterLandscapeDependencies::stream).orElse(Stream.of(new JHipsterLandscapeDependency[0]));
    }

    private long dependenciesCount(JHipsterLandscapeModule module) {
        return module.dependencies().map(JHipsterLandscapeDependencies::count).orElse(0L);
    }

    public JHipsterLandscapeLevels levels() {
        return this.levels;
    }
}

