/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.javabuildprofile;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.buildproperties.BuildProperty;
import tech.jhipster.lite.module.domain.buildproperties.PropertyKey;
import tech.jhipster.lite.module.domain.buildproperties.PropertyValue;
import tech.jhipster.lite.module.domain.javabuild.command.AddJavaBuildProfile;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommand;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommands;
import tech.jhipster.lite.module.domain.javabuild.command.SetBuildProperty;
import tech.jhipster.lite.module.domain.javabuildprofile.BuildProfileId;
import tech.jhipster.lite.module.domain.javabuildprofile.JHipsterModuleJavaBuildProfile;
import tech.jhipster.lite.module.domain.javadependency.JavaDependenciesVersions;
import tech.jhipster.lite.module.domain.javadependency.ProjectJavaDependencies;
import tech.jhipster.lite.shared.error.domain.Assert;

public class JHipsterModuleJavaBuildProfiles {
    private final Collection<JHipsterModuleJavaBuildProfile> profiles;

    private JHipsterModuleJavaBuildProfiles(JHipsterModuleJavaBuildProfilesBuilder builder) {
        this.profiles = builder.profiles.values().stream().map(JHipsterModuleJavaBuildProfile.JHipsterModuleJavaBuildProfileBuilder::build).toList();
    }

    public static JHipsterModuleJavaBuildProfilesBuilder builder(JHipsterModule.JHipsterModuleBuilder module) {
        return new JHipsterModuleJavaBuildProfilesBuilder(module);
    }

    public JavaBuildCommands buildChanges(JavaDependenciesVersions versions, ProjectJavaDependencies projectJavaDependencies) {
        Stream<JavaBuildCommand> addProfileCommands = this.profiles.stream().map(this.toAddProfileCommands());
        Stream<JavaBuildCommand> addPropertyCommands = this.profiles.stream().flatMap(this.toAddPropertyCommands());
        Stream<JavaBuildCommand> mavenPluginCommands = this.profiles.stream().flatMap(this.toMavenPluginCommands(versions, projectJavaDependencies));
        List<JavaBuildCommand> commands = Stream.of(addProfileCommands, addPropertyCommands, mavenPluginCommands).flatMap(Function.identity()).toList();
        return new JavaBuildCommands(commands);
    }

    private Function<JHipsterModuleJavaBuildProfile, JavaBuildCommand> toAddProfileCommands() {
        return profile -> new AddJavaBuildProfile(profile.id(), profile.activation());
    }

    private Function<JHipsterModuleJavaBuildProfile, Stream<JavaBuildCommand>> toAddPropertyCommands() {
        return profile -> profile.properties().entrySet().stream().map(property -> new SetBuildProperty(new BuildProperty((PropertyKey)property.getKey(), (PropertyValue)property.getValue()), profile.id()));
    }

    private Function<JHipsterModuleJavaBuildProfile, Stream<JavaBuildCommand>> toMavenPluginCommands(JavaDependenciesVersions versions, ProjectJavaDependencies projectJavaDependencies) {
        return profile -> profile.mavenPlugins().buildChanges(versions, projectJavaDependencies, profile.id()).commands().stream();
    }

    public static class JHipsterModuleJavaBuildProfilesBuilder {
        private final JHipsterModule.JHipsterModuleBuilder module;
        private final Map<BuildProfileId, JHipsterModuleJavaBuildProfile.JHipsterModuleJavaBuildProfileBuilder> profiles = new HashMap<BuildProfileId, JHipsterModuleJavaBuildProfile.JHipsterModuleJavaBuildProfileBuilder>();

        private JHipsterModuleJavaBuildProfilesBuilder(JHipsterModule.JHipsterModuleBuilder module) {
            Assert.notNull("module", module);
            this.module = module;
        }

        public JHipsterModuleJavaBuildProfile.JHipsterModuleJavaBuildProfileBuilder addProfile(BuildProfileId buildProfileId) {
            Assert.notNull("buildProfileId", buildProfileId);
            return this.profiles.computeIfAbsent(buildProfileId, id -> JHipsterModuleJavaBuildProfile.builder(this, buildProfileId));
        }

        public JHipsterModule.JHipsterModuleBuilder and() {
            return this.module;
        }

        public JHipsterModuleJavaBuildProfiles build() {
            return new JHipsterModuleJavaBuildProfiles(this);
        }
    }
}

