/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.gradleplugin;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.gradleplugin.GradleCommunityPlugin;
import tech.jhipster.lite.module.domain.gradleplugin.GradleCorePlugin;
import tech.jhipster.lite.module.domain.gradleplugin.GradlePlugin;
import tech.jhipster.lite.module.domain.javabuild.command.AddGradlePlugin;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommand;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommands;
import tech.jhipster.lite.module.domain.javadependency.JavaDependenciesVersions;
import tech.jhipster.lite.shared.error.domain.Assert;

public class JHipsterModuleGradlePlugin {
    private final Collection<GradlePlugin> plugins;

    private JHipsterModuleGradlePlugin(JHipsterModuleGradlePluginBuilder builder) {
        Assert.notNull("plugins", builder.plugins);
        this.plugins = builder.plugins;
    }

    public static JHipsterModuleGradlePluginBuilder builder(JHipsterModule.JHipsterModuleBuilder module) {
        return new JHipsterModuleGradlePluginBuilder(module);
    }

    public JavaBuildCommands buildChanges(JavaDependenciesVersions versions) {
        Assert.notNull("versions", versions);
        return new JavaBuildCommands(this.plugins.stream().map(this.toCommands(versions)).toList());
    }

    private Function<GradlePlugin, JavaBuildCommand> toCommands(JavaDependenciesVersions versions) {
        return plugin -> {
            GradlePlugin gradlePlugin = plugin;
            Objects.requireNonNull(gradlePlugin);
            GradlePlugin selector0$temp = gradlePlugin;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GradleCorePlugin.class, GradleCommunityPlugin.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    GradleCorePlugin corePlugin = (GradleCorePlugin)selector0$temp;
                    yield this.mapCorePlugin(corePlugin, versions);
                }
                case 1 -> {
                    GradleCommunityPlugin gradleCommunityPlugin = (GradleCommunityPlugin)selector0$temp;
                    yield this.mapCommunityPlugin(gradleCommunityPlugin, versions);
                }
            };
        };
    }

    private JavaBuildCommand mapCorePlugin(GradleCorePlugin plugin, JavaDependenciesVersions versions) {
        AddGradlePlugin.AddGradlePluginOptionalBuilder commandBuilder = AddGradlePlugin.builder().plugin(plugin);
        plugin.toolVersionSlug().map(versions::get).ifPresent(commandBuilder::toolVersion);
        return commandBuilder.build();
    }

    private JavaBuildCommand mapCommunityPlugin(GradleCommunityPlugin plugin, JavaDependenciesVersions versions) {
        AddGradlePlugin.AddGradlePluginOptionalBuilder commandBuilder = AddGradlePlugin.builder().plugin(plugin);
        plugin.versionSlug().map(versions::get).ifPresent(commandBuilder::pluginVersion);
        return commandBuilder.build();
    }

    public static class JHipsterModuleGradlePluginBuilder {
        private final JHipsterModule.JHipsterModuleBuilder module;
        private final Collection<GradlePlugin> plugins = new ArrayList<GradlePlugin>();

        private JHipsterModuleGradlePluginBuilder(JHipsterModule.JHipsterModuleBuilder module) {
            Assert.notNull("module", module);
            this.module = module;
        }

        public JHipsterModuleGradlePluginBuilder plugin(GradlePlugin plugin) {
            Assert.notNull("plugin", plugin);
            this.plugins.add(plugin);
            return this;
        }

        public JHipsterModule.JHipsterModuleBuilder and() {
            return this.module;
        }

        public JHipsterModuleGradlePlugin build() {
            return new JHipsterModuleGradlePlugin(this);
        }
    }
}

