/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import tech.jhipster.lite.module.domain.GeneratedProjectRepository;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.JHipsterModuleApplied;
import tech.jhipster.lite.module.domain.JHipsterModuleChanges;
import tech.jhipster.lite.module.domain.JHipsterModuleSlug;
import tech.jhipster.lite.module.domain.JHipsterModuleToApply;
import tech.jhipster.lite.module.domain.JHipsterModulesRepository;
import tech.jhipster.lite.module.domain.JHipsterModulesToApply;
import tech.jhipster.lite.module.domain.git.GitRepository;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommands;
import tech.jhipster.lite.module.domain.javadependency.JavaDependenciesVersionsRepository;
import tech.jhipster.lite.module.domain.javadependency.ProjectJavaDependenciesRepository;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;
import tech.jhipster.lite.module.domain.properties.SpringConfigurationFormat;
import tech.jhipster.lite.module.domain.replacement.ContentReplacer;
import tech.jhipster.lite.module.domain.replacement.ContentReplacers;
import tech.jhipster.lite.shared.error.domain.Assert;

public class JHipsterModulesApplyer {
    private final JHipsterModulesRepository modules;
    private final JavaDependenciesVersionsRepository javaVersions;
    private final ProjectJavaDependenciesRepository projectDependencies;
    private final GitRepository git;
    private final GeneratedProjectRepository generatedProject;

    public JHipsterModulesApplyer(JHipsterModulesRepository modules, JavaDependenciesVersionsRepository currentVersions, ProjectJavaDependenciesRepository projectDependencies, GitRepository git, GeneratedProjectRepository generatedProject) {
        this.modules = modules;
        this.javaVersions = currentVersions;
        this.projectDependencies = projectDependencies;
        this.git = git;
        this.generatedProject = generatedProject;
    }

    public Collection<JHipsterModuleApplied> apply(JHipsterModulesToApply modulesToApply) {
        Assert.notNull("modulesToApply", modulesToApply);
        return this.modules.landscape().sort(modulesToApply.slugs()).stream().map(this.toModuleToApply(modulesToApply)).map(this::apply).toList();
    }

    private Function<JHipsterModuleSlug, JHipsterModuleToApply> toModuleToApply(JHipsterModulesToApply modulesToApply) {
        return slug -> new JHipsterModuleToApply((JHipsterModuleSlug)slug, modulesToApply.properties());
    }

    public JHipsterModuleApplied apply(JHipsterModuleToApply moduleToApply) {
        Assert.notNull("moduleToApply", moduleToApply);
        JHipsterModule module = this.modules.resources().build(moduleToApply.slug(), moduleToApply.properties());
        JHipsterModuleChanges.JHipsterModuleChangesSpringPropertiesBuilder builder = JHipsterModuleChanges.builder().projectFolder(module.projectFolder()).indentation(module.indentation()).filesToAdd(module.templatedFiles()).filesToMove(module.filesToMove()).filesToDelete(module.filesToDelete()).replacers(this.buildReplacers(module)).javaBuildCommands(this.buildDependenciesChanges(module).merge(this.buildPluginsChanges(module)).merge(this.buildMavenBuildExtensionsChanges(module)).merge(this.buildProfilesChanges(module)).merge(this.buildGradlePluginsChanges(module))).packageJson(module.packageJson()).preActions(module.preActions()).postActions(module.postActions()).springFactories(module.springFactories());
        JHipsterModuleChanges changes = moduleToApply.properties().configurationFormat() == SpringConfigurationFormat.PROPERTIES ? builder.springProperties(module.springProperties()).springComments(module.springComments()) : builder.springYamlProperties(module.springProperties()).springYamlComments(module.springComments());
        this.modules.apply(changes);
        JHipsterModuleApplied moduleApplied = new JHipsterModuleApplied(moduleToApply.slug(), moduleToApply.properties(), Instant.now());
        this.modules.applied(moduleApplied);
        this.commitIfNeeded(moduleToApply);
        return moduleApplied;
    }

    private ContentReplacers buildReplacers(JHipsterModule module) {
        List<ContentReplacer> replacers = Stream.concat(module.mandatoryReplacements().replacers(), module.optionalReplacements().buildReplacers(module.projectFolder(), this.generatedProject)).toList();
        return new ContentReplacers(replacers);
    }

    private void commitIfNeeded(JHipsterModuleToApply moduleToApply) {
        if (moduleToApply.commitNeeded()) {
            JHipsterProjectFolder projectFolder = moduleToApply.properties().projectFolder();
            this.git.init(projectFolder);
            this.git.commitAll(projectFolder, this.commitMessage(moduleToApply));
        }
    }

    private String commitMessage(JHipsterModuleToApply moduleToApply) {
        return "Apply " + moduleToApply.slug().get() + " module";
    }

    private JavaBuildCommands buildGradlePluginsChanges(JHipsterModule module) {
        return module.gradlePlugins().buildChanges(this.javaVersions.get());
    }

    private JavaBuildCommands buildDependenciesChanges(JHipsterModule module) {
        return module.javaDependencies().buildChanges(this.javaVersions.get(), this.projectDependencies.get(module.projectFolder()));
    }

    private JavaBuildCommands buildProfilesChanges(JHipsterModule module) {
        return module.javaBuildProfiles().buildChanges(this.javaVersions.get(), this.projectDependencies.get(module.projectFolder()));
    }

    private JavaBuildCommands buildPluginsChanges(JHipsterModule module) {
        return module.mavenPlugins().buildChanges(this.javaVersions.get(), this.projectDependencies.get(module.projectFolder()));
    }

    private JavaBuildCommands buildMavenBuildExtensionsChanges(JHipsterModule module) {
        return module.mavenBuildExtensions().buildChanges(this.javaVersions.get());
    }
}

