/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain;

import java.util.ArrayList;
import java.util.Collection;
import tech.jhipster.lite.module.domain.JHipsterFileMatcher;
import tech.jhipster.lite.module.domain.JHipsterProjectFilePath;
import tech.jhipster.lite.module.domain.JHipsterProjectFilesPaths;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterDestinations;
import tech.jhipster.lite.module.domain.replacement.ElementReplacer;
import tech.jhipster.lite.module.domain.replacement.JHipsterUpgradeFilesReplacement;
import tech.jhipster.lite.module.domain.replacement.JHipsterUpgradeFilesReplacements;
import tech.jhipster.lite.shared.error.domain.Assert;

public class JHipsterModuleUpgrade {
    private final JHipsterDestinations skippedFiles;
    private final JHipsterProjectFilesPaths filesToDelete;
    private final JHipsterUpgradeFilesReplacements replacements;

    private JHipsterModuleUpgrade(JHipsterModuleUpgradeBuilder builder) {
        this.skippedFiles = new JHipsterDestinations(builder.skippedFiles);
        this.filesToDelete = new JHipsterProjectFilesPaths(builder.filesToDelete);
        this.replacements = new JHipsterUpgradeFilesReplacements(builder.replacements);
    }

    public static JHipsterModuleUpgradeBuilder builder() {
        return new JHipsterModuleUpgradeBuilder();
    }

    public JHipsterDestinations skippedFiles() {
        return this.skippedFiles;
    }

    public JHipsterProjectFilesPaths filesToDelete() {
        return this.filesToDelete;
    }

    public JHipsterUpgradeFilesReplacements replacements() {
        return this.replacements;
    }

    public static class JHipsterModuleUpgradeBuilder {
        private final Collection<JHipsterDestination> skippedFiles = new ArrayList<JHipsterDestination>();
        private final Collection<JHipsterProjectFilePath> filesToDelete = new ArrayList<JHipsterProjectFilePath>();
        private final Collection<JHipsterUpgradeFilesReplacement> replacements = new ArrayList<JHipsterUpgradeFilesReplacement>();

        public JHipsterModuleUpgradeBuilder doNotAdd(JHipsterDestination file) {
            Assert.notNull("file", file);
            this.skippedFiles.add(file);
            return this;
        }

        public JHipsterModuleUpgradeBuilder delete(JHipsterProjectFilePath path) {
            Assert.notNull("path", path);
            this.filesToDelete.add(path);
            return this;
        }

        public JHipsterModuleUpgradeBuilder replace(JHipsterFileMatcher files, ElementReplacer replacer, String replacement) {
            this.replacements.add(new JHipsterUpgradeFilesReplacement(files, replacer, replacement));
            return this;
        }

        public JHipsterModuleUpgrade build() {
            return new JHipsterModuleUpgrade(this);
        }
    }
}

