/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.springcloud.consul.domain;

import tech.jhipster.lite.generator.base64.domain.Base64Utils;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.LogLevel;
import tech.jhipster.lite.module.domain.docker.DockerImageVersion;
import tech.jhipster.lite.module.domain.docker.DockerImages;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyType;
import tech.jhipster.lite.module.domain.javaproperties.PropertyValue;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class ConsulModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/springcloud/consul");
    private static final GroupId SPRING_CLOUD_GROUP_ID = JHipsterModule.groupId("org.springframework.cloud");
    private static final PropertyValue FALSE_VALUE = JHipsterModule.propertyValue(false);
    private static final PropertyValue TRUE_VALUE = JHipsterModule.propertyValue(true);
    private static final String DOCKER_IMAGE_CONSUL = "consul";
    private static final String DOCKER_IMAGE_CONFIG_LOADER = "jhipster/consul-config-loader";
    private static final String DOCKER_COMPOSE_COMMAND = "docker compose -f src/main/docker/consul.yml up -d";
    private final DockerImages dockerImages;

    public ConsulModuleFactory(DockerImages dockerImages) {
        this.dockerImages = dockerImages;
    }

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String baseName = properties.projectBaseName().get();
        DockerImageVersion dockerImageConsul = this.dockerImages.get(DOCKER_IMAGE_CONSUL);
        DockerImageVersion dockerImageConfigLoader = this.dockerImages.get(DOCKER_IMAGE_CONFIG_LOADER);
        JHipsterModule.JHipsterModuleBuilder builder = JHipsterModule.moduleBuilder(properties).context().put("dockerImageConsul", dockerImageConsul.fullName()).put("dockerImageConfigLoader", dockerImageConfigLoader.fullName()).put("base64JwtSecret", Base64Utils.getBase64Secret()).and().files().add(SOURCE.append("src").template("consul.yml"), JHipsterModule.toSrcMainDocker().append("consul.yml")).add(SOURCE.append("docker").template("application.config.yml.mustache"), JHipsterModule.toSrcMainDocker().append("central-server-config").append("application.yml")).and().javaDependencies().addDependencyManagement(ConsulModuleFactory.springCloudDependencyManagement()).addDependency(SPRING_CLOUD_GROUP_ID, JHipsterModule.artifactId("spring-cloud-starter-bootstrap")).addDependency(SPRING_CLOUD_GROUP_ID, JHipsterModule.artifactId("spring-cloud-starter-consul-discovery")).addDependency(SPRING_CLOUD_GROUP_ID, JHipsterModule.artifactId("spring-cloud-starter-consul-config")).and().startupCommand(DOCKER_COMPOSE_COMMAND).springMainBootstrapProperties().set(JHipsterModule.propertyKey("spring.application.name"), JHipsterModule.propertyValue(baseName)).set(JHipsterModule.propertyKey("spring.cloud.consul.host"), JHipsterModule.propertyValue("localhost")).set(JHipsterModule.propertyKey("spring.cloud.consul.port"), JHipsterModule.propertyValue(8500)).set(JHipsterModule.propertyKey("spring.cloud.compatibility-verifier.enabled"), FALSE_VALUE).set(JHipsterModule.propertyKey("spring.cloud.consul.config.format"), JHipsterModule.propertyValue("yaml")).set(JHipsterModule.propertyKey("spring.cloud.consul.config.profile-separator"), JHipsterModule.propertyValue("-")).set(JHipsterModule.propertyKey("spring.cloud.consul.config.watch.enabled"), FALSE_VALUE).set(JHipsterModule.propertyKey("spring.cloud.consul.discovery.health-check-path"), JHipsterModule.propertyValue("${server.servlet.context-path:}/management/health")).set(JHipsterModule.propertyKey("spring.cloud.consul.discovery.tags[0]"), JHipsterModule.propertyValue("version=@project.version@")).set(JHipsterModule.propertyKey("spring.cloud.consul.discovery.tags[1]"), JHipsterModule.propertyValue("context-path=${server.servlet.context-path:}")).set(JHipsterModule.propertyKey("spring.cloud.consul.discovery.tags[2]"), JHipsterModule.propertyValue("profile=${spring.profiles.active:}")).set(JHipsterModule.propertyKey("spring.cloud.consul.discovery.tags[3]"), JHipsterModule.propertyValue("git-version=${git.build.version:}")).set(JHipsterModule.propertyKey("spring.cloud.consul.discovery.tags[4]"), JHipsterModule.propertyValue("git-commit=${git.commit.id.abbrev:}")).set(JHipsterModule.propertyKey("spring.cloud.consul.discovery.tags[5]"), JHipsterModule.propertyValue("git-branch=${git.branch:}")).set(JHipsterModule.propertyKey("spring.cloud.consul.discovery.instance-id"), JHipsterModule.propertyValue(baseName + ":${spring.application.instance-id:${random.value}}")).set(JHipsterModule.propertyKey("spring.cloud.consul.discovery.service-name"), JHipsterModule.propertyValue(baseName)).set(JHipsterModule.propertyKey("spring.cloud.consul.discovery.prefer-ip-address"), TRUE_VALUE).and().springTestBootstrapProperties().set(JHipsterModule.propertyKey("spring.cloud.consul.enabled"), FALSE_VALUE).set(JHipsterModule.propertyKey("spring.cloud.compatibility-verifier.enabled"), FALSE_VALUE).and().springMainLogger("org.apache", LogLevel.ERROR).springTestLogger("org.apache", LogLevel.ERROR);
        return builder.build();
    }

    private static JavaDependency springCloudDependencyManagement() {
        return JHipsterModule.javaDependency().groupId("org.springframework.cloud").artifactId("spring-cloud-dependencies").versionSlug("spring-cloud.version").type(JavaDependencyType.POM).scope(JavaDependencyScope.IMPORT).build();
    }
}

