/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.docker.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.gradleplugin.GradlePlugin;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPlugin;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPluginConfiguration;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class SpringBootDockerModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/docker");
    private static final JHipsterSource JIB_SOURCE = SOURCE.append("jib");
    private static final String JAVA_DOCKER_IMAGE = "eclipse-temurin:%s-jre-jammy";

    public JHipsterModule buildJibModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).context().put("mainClass", this.mainClassName(properties)).and().mavenPlugins().plugin(this.mavenJibPlugin(properties)).and().gradlePlugins().plugin(this.gradleJibPlugin(properties)).and().files().add(JIB_SOURCE.template("entrypoint.sh"), JHipsterModule.to("src/main/docker/jib").append("entrypoint.sh")).and().build();
    }

    private String mainClassName(JHipsterModuleProperties properties) {
        return properties.basePackage().get() + "." + properties.projectBaseName().capitalized() + "App";
    }

    private MavenPlugin mavenJibPlugin(JHipsterModuleProperties properties) {
        return JHipsterModule.mavenPlugin().groupId("com.google.cloud.tools").artifactId("jib-maven-plugin").versionSlug("jib-maven-plugin").configuration(this.jibPluginConfiguration(properties)).build();
    }

    private String dockerBaseImage(JHipsterModuleProperties properties) {
        return JAVA_DOCKER_IMAGE.formatted(properties.getJavaVersion().get());
    }

    private MavenPluginConfiguration jibPluginConfiguration(JHipsterModuleProperties properties) {
        return new MavenPluginConfiguration("  <from>\n    <image>%s</image>\n    <platforms>\n      <platform>\n        <architecture>amd64</architecture>\n        <os>linux</os>\n      </platform>\n    </platforms>\n  </from>\n  <to>\n    <image>%s:latest</image>\n  </to>\n  <container>\n    <entrypoint>\n      <shell>bash</shell>\n      <option>-c</option>\n      <arg>/entrypoint.sh</arg>\n    </entrypoint>\n    <ports>\n      <port>%s</port>\n    </ports>\n    <environment>\n      <SPRING_OUTPUT_ANSI_ENABLED>ALWAYS</SPRING_OUTPUT_ANSI_ENABLED>\n      <JHIPSTER_SLEEP>0</JHIPSTER_SLEEP>\n    </environment>\n    <creationTime>USE_CURRENT_TIMESTAMP</creationTime>\n    <user>1000</user>\n  </container>\n  <extraDirectories>\n    <paths>src/main/docker/jib</paths>\n    <permissions>\n      <permission>\n        <file>/entrypoint.sh</file>\n        <mode>755</mode>\n      </permission>\n    </permissions>\n  </extraDirectories>\n".formatted(this.dockerBaseImage(properties), properties.projectBaseName().get(), properties.serverPort().get()));
    }

    private GradlePlugin gradleJibPlugin(JHipsterModuleProperties properties) {
        return JHipsterModule.gradleCommunityPlugin().id("com.google.cloud.tools.jib").pluginSlug("jib").versionSlug("jib").configuration("jib {\n  from {\n    image = \"%s\"\n    platforms {\n      platform {\n        architecture = \"amd64\"\n        os = \"linux\"\n      }\n    }\n  }\n  to {\n    image = \"%s:latest\"\n  }\n  container {\n    entrypoint = listOf(\"bash\", \"-c\", \"/entrypoint.sh\")\n    ports = listOf(\"%s\")\n    environment = mapOf(\n     \"SPRING_OUTPUT_ANSI_ENABLED\" to \"ALWAYS\",\n     \"JHIPSTER_SLEEP\" to \"0\"\n    )\n    creationTime = \"USE_CURRENT_TIMESTAMP\"\n    user = \"1000\"\n  }\n  extraDirectories {\n    paths {\n      path {\n        setFrom(\"src/main/docker/jib\")\n      }\n    }\n    permissions = mapOf(\"/entrypoint.sh\" to \"755\")\n  }\n}".formatted(this.dockerBaseImage(properties), properties.projectBaseName().get(), properties.serverPort().get())).build();
    }

    public JHipsterModule buildDockerFileModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).files().add(SOURCE.template("Dockerfile"), JHipsterModule.to("Dockerfile")).and().build();
    }
}

