/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.database.mariadb.domain;

import tech.jhipster.lite.generator.server.springboot.database.common.domain.DatabaseType;
import tech.jhipster.lite.generator.server.springboot.database.sqlcommon.domain.SQLCommonModuleBuilder;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.docker.DockerImages;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class MariaDBModuleFactory {
    private final DockerImages dockerImages;

    public MariaDBModuleFactory(DockerImages dockerImages) {
        Assert.notNull("dockerImages", dockerImages);
        this.dockerImages = dockerImages;
    }

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return SQLCommonModuleBuilder.sqlCommonModuleBuilder(properties, DatabaseType.MARIADB, this.dockerImages.get("mariadb"), JHipsterModule.documentationTitle("MariaDB"), JHipsterModule.artifactId("mariadb")).javaDependencies().addDependency(JHipsterModule.javaDependency().groupId("org.mariadb.jdbc").artifactId("mariadb-java-client").scope(JavaDependencyScope.RUNTIME).build()).and().springMainProperties().set(JHipsterModule.propertyKey("spring.datasource.url"), JHipsterModule.propertyValue("jdbc:mariadb://localhost:3306/" + properties.projectBaseName().name())).set(JHipsterModule.propertyKey("spring.datasource.username"), JHipsterModule.propertyValue("root")).set(JHipsterModule.propertyKey("spring.datasource.driver-class-name"), JHipsterModule.propertyValue("org.mariadb.jdbc.Driver")).and().build();
    }
}

