/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.sonarqube.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.docker.DockerImages;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.mavenplugin.MavenBuildPhase;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPlugin;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class SonarQubeModulesFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/sonar");
    private static final JHipsterDestination SONAR_PROPERTIES_DESTINATION = JHipsterModule.to("sonar-project.properties");
    private final DockerImages dockerImages;

    public SonarQubeModulesFactory(DockerImages dockerImages) {
        this.dockerImages = dockerImages;
    }

    public JHipsterModule buildBackendModule(JHipsterModuleProperties properties) {
        return this.commonModuleFiles(properties).files().add(SOURCE.template("sonar-project.properties"), SONAR_PROPERTIES_DESTINATION).and().build();
    }

    public JHipsterModule buildBackendFrontendModule(JHipsterModuleProperties properties) {
        return this.commonModuleFiles(properties).files().add(SOURCE.template("sonar-fullstack-project.properties"), SONAR_PROPERTIES_DESTINATION).and().build();
    }

    private JHipsterModule.JHipsterModuleBuilder commonModuleFiles(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).context().put("sonarqubeDockerImage", this.dockerImages.get("sonarqube").fullName()).and().documentation(JHipsterModule.documentationTitle("sonar"), SOURCE.template("sonar.md")).startupCommand("docker compose -f src/main/docker/sonar.yml up -d\n./mvnw clean verify sonar:sonar").mavenPlugins().plugin(this.propertiesPlugin()).pluginManagement(this.sonarPlugin()).and().files().add(SOURCE.template("sonar.yml"), JHipsterModule.toSrcMainDocker().append("sonar.yml")).and();
    }

    private MavenPlugin propertiesPlugin() {
        return MavenPlugin.builder().groupId("org.codehaus.mojo").artifactId("properties-maven-plugin").versionSlug("properties-maven-plugin").addExecution(JHipsterModule.pluginExecution().goals("read-project-properties").phase(MavenBuildPhase.INITIALIZE).configuration("<files>\n  <file>sonar-project.properties</file>\n</files>\n")).build();
    }

    private MavenPlugin sonarPlugin() {
        return MavenPlugin.builder().groupId("org.sonarsource.scanner.maven").artifactId("sonar-maven-plugin").versionSlug("sonar-maven-plugin").build();
    }
}

