/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.javatool.frontendmaven.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.mavenplugin.MavenBuildPhase;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPlugin;
import tech.jhipster.lite.module.domain.npm.NpmVersionSource;
import tech.jhipster.lite.module.domain.npm.NpmVersions;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class FrontendMavenModuleFactory {
    private static final String PACKAGE_INFO = "package-info.java";
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/mvc/frontend");
    private static final String REDIRECTION = "wire/frontend";
    private static final String REDIRECTION_PRIMARY = "wire/frontend/infrastructure/primary";
    private final NpmVersions npmVersions;

    public FrontendMavenModuleFactory(NpmVersions npmVersions) {
        this.npmVersions = npmVersions;
    }

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String packagePath = properties.packagePath();
        JHipsterDestination mainDestination = JHipsterModule.toSrcMainJava().append(packagePath);
        return JHipsterModule.moduleBuilder(properties).javaDependencies().setVersion(JHipsterModule.javaDependencyVersion("node", "v" + this.npmVersions.getNodeVersion())).setVersion(JHipsterModule.javaDependencyVersion("npm", this.npmVersions.get("npm", NpmVersionSource.COMMON).get())).and().mavenPlugins().plugin(this.checksumPlugin()).plugin(this.antrunPlugin()).plugin(this.frontendMavenPlugin()).and().files().add(SOURCE.template("RedirectionResource.java"), mainDestination.append(REDIRECTION_PRIMARY).append("RedirectionResource.java")).add(SOURCE.template(PACKAGE_INFO), mainDestination.append(REDIRECTION).append(PACKAGE_INFO)).and().build();
    }

    private MavenPlugin checksumPlugin() {
        return JHipsterModule.mavenPlugin().groupId("net.nicoulaj.maven.plugins").artifactId("checksum-maven-plugin").versionSlug("checksum-maven-plugin").addExecution(JHipsterModule.pluginExecution().goals("files").id("create-pre-compiled-webapp-checksum").phase(MavenBuildPhase.GENERATE_RESOURCES)).addExecution(JHipsterModule.pluginExecution().goals("files").id("create-compiled-webapp-checksum").phase(MavenBuildPhase.COMPILE).configuration("<csvSummaryFile>checksums.csv.old</csvSummaryFile>\n")).configuration("  <fileSets>\n    <fileSet>\n      <directory>${project.basedir}</directory>\n      <includes>\n        <include>src/main/webapp/**/*.*</include>\n        <include>target/classes/static/**/*.*</include>\n        <include>package-lock.json</include>\n        <include>package.json</include>\n        <include>tsconfig.json</include>\n      </includes>\n    </fileSet>\n  </fileSets>\n  <failOnError>false</failOnError>\n  <failIfNoFiles>false</failIfNoFiles>\n  <individualFiles>false</individualFiles>\n  <algorithms>\n    <algorithm>SHA-1</algorithm>\n  </algorithms>\n  <includeRelativePath>true</includeRelativePath>\n  <quiet>true</quiet>\n").build();
    }

    private MavenPlugin antrunPlugin() {
        return JHipsterModule.mavenPlugin().groupId("org.apache.maven.plugins").artifactId("maven-antrun-plugin").versionSlug("maven-antrun-plugin").addExecution(JHipsterModule.pluginExecution().goals("run").id("eval-frontend-checksum").phase(MavenBuildPhase.GENERATE_RESOURCES).configuration("<target>\n  <condition property=\"skip.npm\" value=\"true\" else=\"false\">\n    <and>\n      <available file=\"checksums.csv\" filepath=\"${project.build.directory}\" />\n      <available file=\"checksums.csv.old\" filepath=\"${project.build.directory}\" />\n      <filesmatch file1=\"${project.build.directory}/checksums.csv\" file2=\"${project.build.directory}/checksums.csv.old\" />\n    </and>\n  </condition>\n</target>\n<exportAntProperties>true</exportAntProperties>\n")).build();
    }

    private MavenPlugin frontendMavenPlugin() {
        return JHipsterModule.mavenPlugin().groupId("com.github.eirslett").artifactId("frontend-maven-plugin").versionSlug("frontend-maven-plugin").addExecution(JHipsterModule.pluginExecution().goals("install-node-and-npm").id("install-node-and-npm").configuration("<nodeVersion>${node.version}</nodeVersion>\n<npmVersion>${npm.version}</npmVersion>\n")).addExecution(JHipsterModule.pluginExecution().goals("npm").id("npm install")).addExecution(JHipsterModule.pluginExecution().goals("npm").id("build front").phase(MavenBuildPhase.GENERATE_RESOURCES).configuration("<arguments>run build</arguments>\n<environmentVariables>\n  <APP_VERSION>${project.version}</APP_VERSION>\n</environmentVariables>\n<npmInheritsProxyConfigFromMaven>false</npmInheritsProxyConfigFromMaven>\n")).addExecution(JHipsterModule.pluginExecution().goals("npm").id("front test").phase(MavenBuildPhase.TEST).configuration("<arguments>run test</arguments>\n<npmInheritsProxyConfigFromMaven>false</npmInheritsProxyConfigFromMaven>\n")).build();
    }
}

