/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.buildtool.gradle.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class GradleModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("buildtool/gradle");

    public JHipsterModule buildGradleModule(JHipsterModuleProperties properties) {
        return GradleModuleFactory.gradleWrapperModulesFiles(properties).context().put("dasherizedBaseName", properties.projectBaseName().kebabCase()).and().files().batch(SOURCE, JHipsterModule.to(".")).addTemplate("build.gradle.kts").addTemplate("settings.gradle.kts").and().batch(SOURCE.append("gradle"), JHipsterModule.to("gradle")).addFile("libs.versions.toml").and().and().javaDependencies().addDependency(GradleModuleFactory.junitEngineDependency()).addDependency(GradleModuleFactory.junitParamsDependency()).addDependency(GradleModuleFactory.assertjDependency()).addDependency(GradleModuleFactory.mockitoDependency()).and().build();
    }

    private static JavaDependency junitEngineDependency() {
        return JHipsterModule.javaDependency().groupId("org.junit.jupiter").artifactId("junit-jupiter-engine").versionSlug("junit-jupiter.version").dependencySlug("junit-engine").scope(JavaDependencyScope.TEST).build();
    }

    private static JavaDependency junitParamsDependency() {
        return JHipsterModule.javaDependency().groupId("org.junit.jupiter").artifactId("junit-jupiter-params").versionSlug("junit-jupiter.version").dependencySlug("junit-params").scope(JavaDependencyScope.TEST).build();
    }

    private static JavaDependency assertjDependency() {
        return JHipsterModule.javaDependency().groupId("org.assertj").artifactId("assertj-core").versionSlug("assertj.version").dependencySlug("assertj").scope(JavaDependencyScope.TEST).build();
    }

    private static JavaDependency mockitoDependency() {
        return JHipsterModule.javaDependency().groupId("org.mockito").artifactId("mockito-junit-jupiter").versionSlug("mockito.version").dependencySlug("mockito").scope(JavaDependencyScope.TEST).build();
    }

    public JHipsterModule buildGradleWrapperModule(JHipsterModuleProperties properties) {
        return GradleModuleFactory.gradleWrapperModulesFiles(properties).build();
    }

    private static JHipsterModule.JHipsterModuleBuilder gradleWrapperModulesFiles(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).files().batch(SOURCE.append("gradle/wrapper"), JHipsterModule.to("gradle/wrapper")).addFile("gradle-wrapper.properties").addFile("gradle-wrapper.jar").and().addExecutable(SOURCE.file("gradlew"), JHipsterModule.to("gradlew")).addExecutable(SOURCE.file("gradlew.bat"), JHipsterModule.to("gradlew.bat")).and();
    }
}

