/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.project.infrastructure.secondary;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportRuntimeHints;
import tech.jhipster.lite.project.infrastructure.secondary.NativeHints;
import tech.jhipster.lite.project.infrastructure.secondary.NpmInstallationReader;
import tech.jhipster.lite.project.infrastructure.secondary.NpmInstallationType;
import tech.jhipster.lite.project.infrastructure.secondary.NpmProjectFormatter;
import tech.jhipster.lite.project.infrastructure.secondary.ProjectFormatter;
import tech.jhipster.lite.project.infrastructure.secondary.TraceProjectFormatter;

@Configuration
@ImportRuntimeHints(value={NativeHints.class})
class ProjectFormatterConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ProjectFormatterConfiguration.class);

    ProjectFormatterConfiguration() {
    }

    @Bean
    public ProjectFormatter projectFormatter(NpmInstallationReader npmInstallation) {
        return switch (npmInstallation.get()) {
            default -> throw new MatchException(null, null);
            case NpmInstallationType.UNIX -> this.unixFormatter();
            case NpmInstallationType.WINDOWS -> this.windowsFormatter();
            case NpmInstallationType.NONE -> this.traceFormatter();
        };
    }

    private NpmProjectFormatter unixFormatter() {
        log.info("Using unix formatter");
        return new NpmProjectFormatter("npm");
    }

    private NpmProjectFormatter windowsFormatter() {
        log.info("Using windows formatter");
        return new NpmProjectFormatter("npm.cmd");
    }

    private TraceProjectFormatter traceFormatter() {
        log.info("Using trace formatter");
        return new TraceProjectFormatter();
    }
}

