/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.project.application;

import org.springframework.stereotype.Service;
import tech.jhipster.lite.project.domain.ProjectPath;
import tech.jhipster.lite.project.domain.ProjectsRepository;
import tech.jhipster.lite.project.domain.download.Project;
import tech.jhipster.lite.project.domain.download.ProjectsDownloader;
import tech.jhipster.lite.project.domain.history.ProjectActionToAppend;
import tech.jhipster.lite.project.domain.history.ProjectActionsAppender;
import tech.jhipster.lite.project.domain.history.ProjectHistory;
import tech.jhipster.lite.shared.projectfolder.domain.ProjectFolder;

@Service
public class ProjectsApplicationService {
    private final ProjectsRepository projects;
    private final ProjectsDownloader downloader;
    private final ProjectActionsAppender actionsAppender;

    public ProjectsApplicationService(ProjectFolder projectFolder, ProjectsRepository projects) {
        this.projects = projects;
        this.downloader = new ProjectsDownloader(projectFolder, projects);
        this.actionsAppender = new ProjectActionsAppender(projects);
    }

    public void format(ProjectPath path) {
        this.projects.format(path);
    }

    public Project get(ProjectPath path) {
        return this.downloader.download(path);
    }

    public void append(ProjectActionToAppend actionToAppend) {
        this.actionsAppender.append(actionToAppend);
    }

    public ProjectHistory getHistory(ProjectPath path) {
        return this.projects.getHistory(path);
    }
}

